/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.waf.v20180125.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeAttackOverviewResponse extends AbstractModel {

    /**
    * Total number of access requests
    */
    @SerializedName("AccessCount")
    @Expose
    private Long AccessCount;

    /**
    * Total web attacks
    */
    @SerializedName("AttackCount")
    @Expose
    private Long AttackCount;

    /**
    * Total number of access controls
    */
    @SerializedName("ACLCount")
    @Expose
    private Long ACLCount;

    /**
    * Total CC attacks
    */
    @SerializedName("CCCount")
    @Expose
    private Long CCCount;

    /**
    * Total bot attack count
    */
    @SerializedName("BotCount")
    @Expose
    private Long BotCount;

    /**
    * Total API assets
    */
    @SerializedName("ApiAssetsCount")
    @Expose
    private Long ApiAssetsCount;

    /**
    * Number of API risk events

Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("ApiRiskEventCount")
    @Expose
    private Long ApiRiskEventCount;

    /**
    * Total number of blocklisted IP addresses.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("IPBlackCount")
    @Expose
    private Long IPBlackCount;

    /**
    * Total number of tamper-proof items

Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("TamperCount")
    @Expose
    private Long TamperCount;

    /**
    * Total number of information leaks

Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("LeakCount")
    @Expose
    private Long LeakCount;

    /**
    * Weekly proportion of API risk events.

Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("ApiRiskEventCircleCount")
    @Expose
    private Long ApiRiskEventCircleCount;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total number of access requests 
     * @return AccessCount Total number of access requests
     */
    public Long getAccessCount() {
        return this.AccessCount;
    }

    /**
     * Set Total number of access requests
     * @param AccessCount Total number of access requests
     */
    public void setAccessCount(Long AccessCount) {
        this.AccessCount = AccessCount;
    }

    /**
     * Get Total web attacks 
     * @return AttackCount Total web attacks
     */
    public Long getAttackCount() {
        return this.AttackCount;
    }

    /**
     * Set Total web attacks
     * @param AttackCount Total web attacks
     */
    public void setAttackCount(Long AttackCount) {
        this.AttackCount = AttackCount;
    }

    /**
     * Get Total number of access controls 
     * @return ACLCount Total number of access controls
     */
    public Long getACLCount() {
        return this.ACLCount;
    }

    /**
     * Set Total number of access controls
     * @param ACLCount Total number of access controls
     */
    public void setACLCount(Long ACLCount) {
        this.ACLCount = ACLCount;
    }

    /**
     * Get Total CC attacks 
     * @return CCCount Total CC attacks
     */
    public Long getCCCount() {
        return this.CCCount;
    }

    /**
     * Set Total CC attacks
     * @param CCCount Total CC attacks
     */
    public void setCCCount(Long CCCount) {
        this.CCCount = CCCount;
    }

    /**
     * Get Total bot attack count 
     * @return BotCount Total bot attack count
     */
    public Long getBotCount() {
        return this.BotCount;
    }

    /**
     * Set Total bot attack count
     * @param BotCount Total bot attack count
     */
    public void setBotCount(Long BotCount) {
        this.BotCount = BotCount;
    }

    /**
     * Get Total API assets 
     * @return ApiAssetsCount Total API assets
     */
    public Long getApiAssetsCount() {
        return this.ApiAssetsCount;
    }

    /**
     * Set Total API assets
     * @param ApiAssetsCount Total API assets
     */
    public void setApiAssetsCount(Long ApiAssetsCount) {
        this.ApiAssetsCount = ApiAssetsCount;
    }

    /**
     * Get Number of API risk events

Note: This field may return null, indicating that no valid values can be obtained. 
     * @return ApiRiskEventCount Number of API risk events

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getApiRiskEventCount() {
        return this.ApiRiskEventCount;
    }

    /**
     * Set Number of API risk events

Note: This field may return null, indicating that no valid values can be obtained.
     * @param ApiRiskEventCount Number of API risk events

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setApiRiskEventCount(Long ApiRiskEventCount) {
        this.ApiRiskEventCount = ApiRiskEventCount;
    }

    /**
     * Get Total number of blocklisted IP addresses.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return IPBlackCount Total number of blocklisted IP addresses.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getIPBlackCount() {
        return this.IPBlackCount;
    }

    /**
     * Set Total number of blocklisted IP addresses.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param IPBlackCount Total number of blocklisted IP addresses.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setIPBlackCount(Long IPBlackCount) {
        this.IPBlackCount = IPBlackCount;
    }

    /**
     * Get Total number of tamper-proof items

Note: This field may return null, indicating that no valid values can be obtained. 
     * @return TamperCount Total number of tamper-proof items

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getTamperCount() {
        return this.TamperCount;
    }

    /**
     * Set Total number of tamper-proof items

Note: This field may return null, indicating that no valid values can be obtained.
     * @param TamperCount Total number of tamper-proof items

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setTamperCount(Long TamperCount) {
        this.TamperCount = TamperCount;
    }

    /**
     * Get Total number of information leaks

Note: This field may return null, indicating that no valid values can be obtained. 
     * @return LeakCount Total number of information leaks

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getLeakCount() {
        return this.LeakCount;
    }

    /**
     * Set Total number of information leaks

Note: This field may return null, indicating that no valid values can be obtained.
     * @param LeakCount Total number of information leaks

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setLeakCount(Long LeakCount) {
        this.LeakCount = LeakCount;
    }

    /**
     * Get Weekly proportion of API risk events.

Note: This field may return null, indicating that no valid values can be obtained. 
     * @return ApiRiskEventCircleCount Weekly proportion of API risk events.

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getApiRiskEventCircleCount() {
        return this.ApiRiskEventCircleCount;
    }

    /**
     * Set Weekly proportion of API risk events.

Note: This field may return null, indicating that no valid values can be obtained.
     * @param ApiRiskEventCircleCount Weekly proportion of API risk events.

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setApiRiskEventCircleCount(Long ApiRiskEventCircleCount) {
        this.ApiRiskEventCircleCount = ApiRiskEventCircleCount;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeAttackOverviewResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeAttackOverviewResponse(DescribeAttackOverviewResponse source) {
        if (source.AccessCount != null) {
            this.AccessCount = new Long(source.AccessCount);
        }
        if (source.AttackCount != null) {
            this.AttackCount = new Long(source.AttackCount);
        }
        if (source.ACLCount != null) {
            this.ACLCount = new Long(source.ACLCount);
        }
        if (source.CCCount != null) {
            this.CCCount = new Long(source.CCCount);
        }
        if (source.BotCount != null) {
            this.BotCount = new Long(source.BotCount);
        }
        if (source.ApiAssetsCount != null) {
            this.ApiAssetsCount = new Long(source.ApiAssetsCount);
        }
        if (source.ApiRiskEventCount != null) {
            this.ApiRiskEventCount = new Long(source.ApiRiskEventCount);
        }
        if (source.IPBlackCount != null) {
            this.IPBlackCount = new Long(source.IPBlackCount);
        }
        if (source.TamperCount != null) {
            this.TamperCount = new Long(source.TamperCount);
        }
        if (source.LeakCount != null) {
            this.LeakCount = new Long(source.LeakCount);
        }
        if (source.ApiRiskEventCircleCount != null) {
            this.ApiRiskEventCircleCount = new Long(source.ApiRiskEventCircleCount);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "AccessCount", this.AccessCount);
        this.setParamSimple(map, prefix + "AttackCount", this.AttackCount);
        this.setParamSimple(map, prefix + "ACLCount", this.ACLCount);
        this.setParamSimple(map, prefix + "CCCount", this.CCCount);
        this.setParamSimple(map, prefix + "BotCount", this.BotCount);
        this.setParamSimple(map, prefix + "ApiAssetsCount", this.ApiAssetsCount);
        this.setParamSimple(map, prefix + "ApiRiskEventCount", this.ApiRiskEventCount);
        this.setParamSimple(map, prefix + "IPBlackCount", this.IPBlackCount);
        this.setParamSimple(map, prefix + "TamperCount", this.TamperCount);
        this.setParamSimple(map, prefix + "LeakCount", this.LeakCount);
        this.setParamSimple(map, prefix + "ApiRiskEventCircleCount", this.ApiRiskEventCircleCount);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

