/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.waf.v20180125.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeCertificateVerifyResultResponse extends AbstractModel {

    /**
    * Status code
0: normal certificate
310: abnormal certificate
311: certificate expired
312: certificate about to expire
    */
    @SerializedName("Status")
    @Expose
    private Long Status;

    /**
    * Error details
    */
    @SerializedName("Detail")
    @Expose
    private String [] Detail;

    /**
    * Expiration time
    */
    @SerializedName("NotAfter")
    @Expose
    private String NotAfter;

    /**
    * Whether the certificate is changed
0: not changed
1: changed
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Changed")
    @Expose
    private Long Changed;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Status code
0: normal certificate
310: abnormal certificate
311: certificate expired
312: certificate about to expire 
     * @return Status Status code
0: normal certificate
310: abnormal certificate
311: certificate expired
312: certificate about to expire
     */
    public Long getStatus() {
        return this.Status;
    }

    /**
     * Set Status code
0: normal certificate
310: abnormal certificate
311: certificate expired
312: certificate about to expire
     * @param Status Status code
0: normal certificate
310: abnormal certificate
311: certificate expired
312: certificate about to expire
     */
    public void setStatus(Long Status) {
        this.Status = Status;
    }

    /**
     * Get Error details 
     * @return Detail Error details
     */
    public String [] getDetail() {
        return this.Detail;
    }

    /**
     * Set Error details
     * @param Detail Error details
     */
    public void setDetail(String [] Detail) {
        this.Detail = Detail;
    }

    /**
     * Get Expiration time 
     * @return NotAfter Expiration time
     */
    public String getNotAfter() {
        return this.NotAfter;
    }

    /**
     * Set Expiration time
     * @param NotAfter Expiration time
     */
    public void setNotAfter(String NotAfter) {
        this.NotAfter = NotAfter;
    }

    /**
     * Get Whether the certificate is changed
0: not changed
1: changed
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Changed Whether the certificate is changed
0: not changed
1: changed
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getChanged() {
        return this.Changed;
    }

    /**
     * Set Whether the certificate is changed
0: not changed
1: changed
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Changed Whether the certificate is changed
0: not changed
1: changed
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setChanged(Long Changed) {
        this.Changed = Changed;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeCertificateVerifyResultResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeCertificateVerifyResultResponse(DescribeCertificateVerifyResultResponse source) {
        if (source.Status != null) {
            this.Status = new Long(source.Status);
        }
        if (source.Detail != null) {
            this.Detail = new String[source.Detail.length];
            for (int i = 0; i < source.Detail.length; i++) {
                this.Detail[i] = new String(source.Detail[i]);
            }
        }
        if (source.NotAfter != null) {
            this.NotAfter = new String(source.NotAfter);
        }
        if (source.Changed != null) {
            this.Changed = new Long(source.Changed);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Status", this.Status);
        this.setParamArraySimple(map, prefix + "Detail.", this.Detail);
        this.setParamSimple(map, prefix + "NotAfter", this.NotAfter);
        this.setParamSimple(map, prefix + "Changed", this.Changed);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

