/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.waf.v20180125.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeDomainCountInfoResponse extends AbstractModel {

    /**
    * Total number of domain names
    */
    @SerializedName("AllDomain")
    @Expose
    private Long AllDomain;

    /**
    * Last discovery time
    */
    @SerializedName("UpdateTime")
    @Expose
    private String UpdateTime;

    /**
    * Total number of connected domains
    */
    @SerializedName("WafDomainCount")
    @Expose
    private Long WafDomainCount;

    /**
    * Remaining quota
    */
    @SerializedName("LeftDomainCount")
    @Expose
    private Long LeftDomainCount;

    /**
    * Number of protected domain names
    */
    @SerializedName("OpenWafDomain")
    @Expose
    private Long OpenWafDomain;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total number of domain names 
     * @return AllDomain Total number of domain names
     */
    public Long getAllDomain() {
        return this.AllDomain;
    }

    /**
     * Set Total number of domain names
     * @param AllDomain Total number of domain names
     */
    public void setAllDomain(Long AllDomain) {
        this.AllDomain = AllDomain;
    }

    /**
     * Get Last discovery time 
     * @return UpdateTime Last discovery time
     */
    public String getUpdateTime() {
        return this.UpdateTime;
    }

    /**
     * Set Last discovery time
     * @param UpdateTime Last discovery time
     */
    public void setUpdateTime(String UpdateTime) {
        this.UpdateTime = UpdateTime;
    }

    /**
     * Get Total number of connected domains 
     * @return WafDomainCount Total number of connected domains
     */
    public Long getWafDomainCount() {
        return this.WafDomainCount;
    }

    /**
     * Set Total number of connected domains
     * @param WafDomainCount Total number of connected domains
     */
    public void setWafDomainCount(Long WafDomainCount) {
        this.WafDomainCount = WafDomainCount;
    }

    /**
     * Get Remaining quota 
     * @return LeftDomainCount Remaining quota
     */
    public Long getLeftDomainCount() {
        return this.LeftDomainCount;
    }

    /**
     * Set Remaining quota
     * @param LeftDomainCount Remaining quota
     */
    public void setLeftDomainCount(Long LeftDomainCount) {
        this.LeftDomainCount = LeftDomainCount;
    }

    /**
     * Get Number of protected domain names 
     * @return OpenWafDomain Number of protected domain names
     */
    public Long getOpenWafDomain() {
        return this.OpenWafDomain;
    }

    /**
     * Set Number of protected domain names
     * @param OpenWafDomain Number of protected domain names
     */
    public void setOpenWafDomain(Long OpenWafDomain) {
        this.OpenWafDomain = OpenWafDomain;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeDomainCountInfoResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeDomainCountInfoResponse(DescribeDomainCountInfoResponse source) {
        if (source.AllDomain != null) {
            this.AllDomain = new Long(source.AllDomain);
        }
        if (source.UpdateTime != null) {
            this.UpdateTime = new String(source.UpdateTime);
        }
        if (source.WafDomainCount != null) {
            this.WafDomainCount = new Long(source.WafDomainCount);
        }
        if (source.LeftDomainCount != null) {
            this.LeftDomainCount = new Long(source.LeftDomainCount);
        }
        if (source.OpenWafDomain != null) {
            this.OpenWafDomain = new Long(source.OpenWafDomain);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "AllDomain", this.AllDomain);
        this.setParamSimple(map, prefix + "UpdateTime", this.UpdateTime);
        this.setParamSimple(map, prefix + "WafDomainCount", this.WafDomainCount);
        this.setParamSimple(map, prefix + "LeftDomainCount", this.LeftDomainCount);
        this.setParamSimple(map, prefix + "OpenWafDomain", this.OpenWafDomain);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

