/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.waf.v20180125.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeDomainVerifyResultResponse extends AbstractModel {

    /**
    * Result description: if possible, return an empty string
    */
    @SerializedName("Msg")
    @Expose
    private String Msg;

    /**
    * Inspection status. 0 indicates that it can be added; greater than 0 indicates that it cannot be added.
    */
    @SerializedName("VerifyCode")
    @Expose
    private Long VerifyCode;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Result description: if possible, return an empty string 
     * @return Msg Result description: if possible, return an empty string
     */
    public String getMsg() {
        return this.Msg;
    }

    /**
     * Set Result description: if possible, return an empty string
     * @param Msg Result description: if possible, return an empty string
     */
    public void setMsg(String Msg) {
        this.Msg = Msg;
    }

    /**
     * Get Inspection status. 0 indicates that it can be added; greater than 0 indicates that it cannot be added. 
     * @return VerifyCode Inspection status. 0 indicates that it can be added; greater than 0 indicates that it cannot be added.
     */
    public Long getVerifyCode() {
        return this.VerifyCode;
    }

    /**
     * Set Inspection status. 0 indicates that it can be added; greater than 0 indicates that it cannot be added.
     * @param VerifyCode Inspection status. 0 indicates that it can be added; greater than 0 indicates that it cannot be added.
     */
    public void setVerifyCode(Long VerifyCode) {
        this.VerifyCode = VerifyCode;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeDomainVerifyResultResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeDomainVerifyResultResponse(DescribeDomainVerifyResultResponse source) {
        if (source.Msg != null) {
            this.Msg = new String(source.Msg);
        }
        if (source.VerifyCode != null) {
            this.VerifyCode = new Long(source.VerifyCode);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Msg", this.Msg);
        this.setParamSimple(map, prefix + "VerifyCode", this.VerifyCode);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

