/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.waf.v20180125.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeIpAccessControlResponse extends AbstractModel {

    /**
    * Output.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Data")
    @Expose
    private IpAccessControlData Data;

    /**
    * Total number of IP addresses in the used IP allowlist/blocklist.

Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("UsedTotal")
    @Expose
    private Long UsedTotal;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Output.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Data Output.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public IpAccessControlData getData() {
        return this.Data;
    }

    /**
     * Set Output.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Data Output.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setData(IpAccessControlData Data) {
        this.Data = Data;
    }

    /**
     * Get Total number of IP addresses in the used IP allowlist/blocklist.

Note: This field may return null, indicating that no valid values can be obtained. 
     * @return UsedTotal Total number of IP addresses in the used IP allowlist/blocklist.

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getUsedTotal() {
        return this.UsedTotal;
    }

    /**
     * Set Total number of IP addresses in the used IP allowlist/blocklist.

Note: This field may return null, indicating that no valid values can be obtained.
     * @param UsedTotal Total number of IP addresses in the used IP allowlist/blocklist.

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setUsedTotal(Long UsedTotal) {
        this.UsedTotal = UsedTotal;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeIpAccessControlResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeIpAccessControlResponse(DescribeIpAccessControlResponse source) {
        if (source.Data != null) {
            this.Data = new IpAccessControlData(source.Data);
        }
        if (source.UsedTotal != null) {
            this.UsedTotal = new Long(source.UsedTotal);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamObj(map, prefix + "Data.", this.Data);
        this.setParamSimple(map, prefix + "UsedTotal", this.UsedTotal);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

