/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.waf.v20180125.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeModuleStatusResponse extends AbstractModel {

    /**
    * Whether web security rules are enabled
    */
    @SerializedName("WebSecurity")
    @Expose
    private Long WebSecurity;

    /**
    * Whether access control rule is enabled
    */
    @SerializedName("AccessControl")
    @Expose
    private Long AccessControl;

    /**
    * Whether CC protection is enabled.
    */
    @SerializedName("CcProtection")
    @Expose
    private Long CcProtection;

    /**
    * Whether web tamper-proof is enabled
    */
    @SerializedName("AntiTamper")
    @Expose
    private Long AntiTamper;

    /**
    * Whether information leakage prevention is enabled
    */
    @SerializedName("AntiLeakage")
    @Expose
    private Long AntiLeakage;

    /**
    * Whether API security is enabled
    */
    @SerializedName("ApiProtection")
    @Expose
    private Long ApiProtection;

    /**
    * Traffic limiting module switch
    */
    @SerializedName("RateLimit")
    @Expose
    private Long RateLimit;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Whether web security rules are enabled 
     * @return WebSecurity Whether web security rules are enabled
     */
    public Long getWebSecurity() {
        return this.WebSecurity;
    }

    /**
     * Set Whether web security rules are enabled
     * @param WebSecurity Whether web security rules are enabled
     */
    public void setWebSecurity(Long WebSecurity) {
        this.WebSecurity = WebSecurity;
    }

    /**
     * Get Whether access control rule is enabled 
     * @return AccessControl Whether access control rule is enabled
     */
    public Long getAccessControl() {
        return this.AccessControl;
    }

    /**
     * Set Whether access control rule is enabled
     * @param AccessControl Whether access control rule is enabled
     */
    public void setAccessControl(Long AccessControl) {
        this.AccessControl = AccessControl;
    }

    /**
     * Get Whether CC protection is enabled. 
     * @return CcProtection Whether CC protection is enabled.
     */
    public Long getCcProtection() {
        return this.CcProtection;
    }

    /**
     * Set Whether CC protection is enabled.
     * @param CcProtection Whether CC protection is enabled.
     */
    public void setCcProtection(Long CcProtection) {
        this.CcProtection = CcProtection;
    }

    /**
     * Get Whether web tamper-proof is enabled 
     * @return AntiTamper Whether web tamper-proof is enabled
     */
    public Long getAntiTamper() {
        return this.AntiTamper;
    }

    /**
     * Set Whether web tamper-proof is enabled
     * @param AntiTamper Whether web tamper-proof is enabled
     */
    public void setAntiTamper(Long AntiTamper) {
        this.AntiTamper = AntiTamper;
    }

    /**
     * Get Whether information leakage prevention is enabled 
     * @return AntiLeakage Whether information leakage prevention is enabled
     */
    public Long getAntiLeakage() {
        return this.AntiLeakage;
    }

    /**
     * Set Whether information leakage prevention is enabled
     * @param AntiLeakage Whether information leakage prevention is enabled
     */
    public void setAntiLeakage(Long AntiLeakage) {
        this.AntiLeakage = AntiLeakage;
    }

    /**
     * Get Whether API security is enabled 
     * @return ApiProtection Whether API security is enabled
     */
    public Long getApiProtection() {
        return this.ApiProtection;
    }

    /**
     * Set Whether API security is enabled
     * @param ApiProtection Whether API security is enabled
     */
    public void setApiProtection(Long ApiProtection) {
        this.ApiProtection = ApiProtection;
    }

    /**
     * Get Traffic limiting module switch 
     * @return RateLimit Traffic limiting module switch
     */
    public Long getRateLimit() {
        return this.RateLimit;
    }

    /**
     * Set Traffic limiting module switch
     * @param RateLimit Traffic limiting module switch
     */
    public void setRateLimit(Long RateLimit) {
        this.RateLimit = RateLimit;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeModuleStatusResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeModuleStatusResponse(DescribeModuleStatusResponse source) {
        if (source.WebSecurity != null) {
            this.WebSecurity = new Long(source.WebSecurity);
        }
        if (source.AccessControl != null) {
            this.AccessControl = new Long(source.AccessControl);
        }
        if (source.CcProtection != null) {
            this.CcProtection = new Long(source.CcProtection);
        }
        if (source.AntiTamper != null) {
            this.AntiTamper = new Long(source.AntiTamper);
        }
        if (source.AntiLeakage != null) {
            this.AntiLeakage = new Long(source.AntiLeakage);
        }
        if (source.ApiProtection != null) {
            this.ApiProtection = new Long(source.ApiProtection);
        }
        if (source.RateLimit != null) {
            this.RateLimit = new Long(source.RateLimit);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "WebSecurity", this.WebSecurity);
        this.setParamSimple(map, prefix + "AccessControl", this.AccessControl);
        this.setParamSimple(map, prefix + "CcProtection", this.CcProtection);
        this.setParamSimple(map, prefix + "AntiTamper", this.AntiTamper);
        this.setParamSimple(map, prefix + "AntiLeakage", this.AntiLeakage);
        this.setParamSimple(map, prefix + "ApiProtection", this.ApiProtection);
        this.setParamSimple(map, prefix + "RateLimit", this.RateLimit);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

