/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.waf.v20180125.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeSpartaProtectionInfoResponse extends AbstractModel {

    /**
    * Domain name
    */
    @SerializedName("Domain")
    @Expose
    private String Domain;

    /**
    * Domain ID
    */
    @SerializedName("DomainId")
    @Expose
    private String DomainId;

    /**
    * CNAME value
    */
    @SerializedName("Cname")
    @Expose
    private String Cname;

    /**
    * Status
    */
    @SerializedName("Status")
    @Expose
    private String Status;

    /**
    * Source IP address list
    */
    @SerializedName("SrcList")
    @Expose
    private String [] SrcList;

    /**
    * Certificate type
    */
    @SerializedName("CertType")
    @Expose
    private String CertType;

    /**
    * Certificate
    */
    @SerializedName("Cert")
    @Expose
    private String Cert;

    /**
    * Private key
    */
    @SerializedName("PrivateKey")
    @Expose
    private String PrivateKey;

    /**
    * SSL ID
    */
    @SerializedName("Sslid")
    @Expose
    private String Sslid;

    /**
    * Whether it is a CDN
    */
    @SerializedName("IsCdn")
    @Expose
    private String IsCdn;

    /**
    * Grayscale area list
    */
    @SerializedName("GrayAreas")
    @Expose
    private String [] GrayAreas;

    /**
    * Engine
    */
    @SerializedName("Engine")
    @Expose
    private String Engine;

    /**
    * HTTPS rewriting
    */
    @SerializedName("HttpsRewrite")
    @Expose
    private String HttpsRewrite;

    /**
    * upstreamType value
    */
    @SerializedName("UpstreamType")
    @Expose
    private String UpstreamType;

    /**
    * Value of upstreamDomain
    */
    @SerializedName("UpstreamDomain")
    @Expose
    private String UpstreamDomain;

    /**
    * Value of upstreamScheme
    */
    @SerializedName("UpstreamScheme")
    @Expose
    private String UpstreamScheme;

    /**
    * Whether it is HTTP2.
    */
    @SerializedName("IsHttp2")
    @Expose
    private String IsHttp2;

    /**
    * Whether it includes WebSocket
    */
    @SerializedName("IsWebsocket")
    @Expose
    private String IsWebsocket;

    /**
    * LoadBalance information
    */
    @SerializedName("LoadBalance")
    @Expose
    private String LoadBalance;

    /**
    * Value of httpsUpstreamPort
    */
    @SerializedName("HttpsUpstreamPort")
    @Expose
    private String HttpsUpstreamPort;

    /**
    * Port information
    */
    @SerializedName("Ports")
    @Expose
    private PortItem [] Ports;

    /**
    * Whether it is grayscale
    */
    @SerializedName("IsGray")
    @Expose
    private String IsGray;

    /**
    * Mode
    */
    @SerializedName("Mode")
    @Expose
    private String Mode;

    /**
    * Defense level: 100, 200, 300
    */
    @SerializedName("Level")
    @Expose
    private String Level;

    /**
    * Whether to maintain a long connection with the origin server
    */
    @SerializedName("IsKeepAlive")
    @Expose
    private String IsKeepAlive;

    /**
    * 0: BGP; 1: Anycast.
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Anycast")
    @Expose
    private String Anycast;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Domain name 
     * @return Domain Domain name
     */
    public String getDomain() {
        return this.Domain;
    }

    /**
     * Set Domain name
     * @param Domain Domain name
     */
    public void setDomain(String Domain) {
        this.Domain = Domain;
    }

    /**
     * Get Domain ID 
     * @return DomainId Domain ID
     */
    public String getDomainId() {
        return this.DomainId;
    }

    /**
     * Set Domain ID
     * @param DomainId Domain ID
     */
    public void setDomainId(String DomainId) {
        this.DomainId = DomainId;
    }

    /**
     * Get CNAME value 
     * @return Cname CNAME value
     */
    public String getCname() {
        return this.Cname;
    }

    /**
     * Set CNAME value
     * @param Cname CNAME value
     */
    public void setCname(String Cname) {
        this.Cname = Cname;
    }

    /**
     * Get Status 
     * @return Status Status
     */
    public String getStatus() {
        return this.Status;
    }

    /**
     * Set Status
     * @param Status Status
     */
    public void setStatus(String Status) {
        this.Status = Status;
    }

    /**
     * Get Source IP address list 
     * @return SrcList Source IP address list
     */
    public String [] getSrcList() {
        return this.SrcList;
    }

    /**
     * Set Source IP address list
     * @param SrcList Source IP address list
     */
    public void setSrcList(String [] SrcList) {
        this.SrcList = SrcList;
    }

    /**
     * Get Certificate type 
     * @return CertType Certificate type
     */
    public String getCertType() {
        return this.CertType;
    }

    /**
     * Set Certificate type
     * @param CertType Certificate type
     */
    public void setCertType(String CertType) {
        this.CertType = CertType;
    }

    /**
     * Get Certificate 
     * @return Cert Certificate
     */
    public String getCert() {
        return this.Cert;
    }

    /**
     * Set Certificate
     * @param Cert Certificate
     */
    public void setCert(String Cert) {
        this.Cert = Cert;
    }

    /**
     * Get Private key 
     * @return PrivateKey Private key
     */
    public String getPrivateKey() {
        return this.PrivateKey;
    }

    /**
     * Set Private key
     * @param PrivateKey Private key
     */
    public void setPrivateKey(String PrivateKey) {
        this.PrivateKey = PrivateKey;
    }

    /**
     * Get SSL ID 
     * @return Sslid SSL ID
     */
    public String getSslid() {
        return this.Sslid;
    }

    /**
     * Set SSL ID
     * @param Sslid SSL ID
     */
    public void setSslid(String Sslid) {
        this.Sslid = Sslid;
    }

    /**
     * Get Whether it is a CDN 
     * @return IsCdn Whether it is a CDN
     */
    public String getIsCdn() {
        return this.IsCdn;
    }

    /**
     * Set Whether it is a CDN
     * @param IsCdn Whether it is a CDN
     */
    public void setIsCdn(String IsCdn) {
        this.IsCdn = IsCdn;
    }

    /**
     * Get Grayscale area list 
     * @return GrayAreas Grayscale area list
     */
    public String [] getGrayAreas() {
        return this.GrayAreas;
    }

    /**
     * Set Grayscale area list
     * @param GrayAreas Grayscale area list
     */
    public void setGrayAreas(String [] GrayAreas) {
        this.GrayAreas = GrayAreas;
    }

    /**
     * Get Engine 
     * @return Engine Engine
     */
    public String getEngine() {
        return this.Engine;
    }

    /**
     * Set Engine
     * @param Engine Engine
     */
    public void setEngine(String Engine) {
        this.Engine = Engine;
    }

    /**
     * Get HTTPS rewriting 
     * @return HttpsRewrite HTTPS rewriting
     */
    public String getHttpsRewrite() {
        return this.HttpsRewrite;
    }

    /**
     * Set HTTPS rewriting
     * @param HttpsRewrite HTTPS rewriting
     */
    public void setHttpsRewrite(String HttpsRewrite) {
        this.HttpsRewrite = HttpsRewrite;
    }

    /**
     * Get upstreamType value 
     * @return UpstreamType upstreamType value
     */
    public String getUpstreamType() {
        return this.UpstreamType;
    }

    /**
     * Set upstreamType value
     * @param UpstreamType upstreamType value
     */
    public void setUpstreamType(String UpstreamType) {
        this.UpstreamType = UpstreamType;
    }

    /**
     * Get Value of upstreamDomain 
     * @return UpstreamDomain Value of upstreamDomain
     */
    public String getUpstreamDomain() {
        return this.UpstreamDomain;
    }

    /**
     * Set Value of upstreamDomain
     * @param UpstreamDomain Value of upstreamDomain
     */
    public void setUpstreamDomain(String UpstreamDomain) {
        this.UpstreamDomain = UpstreamDomain;
    }

    /**
     * Get Value of upstreamScheme 
     * @return UpstreamScheme Value of upstreamScheme
     */
    public String getUpstreamScheme() {
        return this.UpstreamScheme;
    }

    /**
     * Set Value of upstreamScheme
     * @param UpstreamScheme Value of upstreamScheme
     */
    public void setUpstreamScheme(String UpstreamScheme) {
        this.UpstreamScheme = UpstreamScheme;
    }

    /**
     * Get Whether it is HTTP2. 
     * @return IsHttp2 Whether it is HTTP2.
     */
    public String getIsHttp2() {
        return this.IsHttp2;
    }

    /**
     * Set Whether it is HTTP2.
     * @param IsHttp2 Whether it is HTTP2.
     */
    public void setIsHttp2(String IsHttp2) {
        this.IsHttp2 = IsHttp2;
    }

    /**
     * Get Whether it includes WebSocket 
     * @return IsWebsocket Whether it includes WebSocket
     */
    public String getIsWebsocket() {
        return this.IsWebsocket;
    }

    /**
     * Set Whether it includes WebSocket
     * @param IsWebsocket Whether it includes WebSocket
     */
    public void setIsWebsocket(String IsWebsocket) {
        this.IsWebsocket = IsWebsocket;
    }

    /**
     * Get LoadBalance information 
     * @return LoadBalance LoadBalance information
     */
    public String getLoadBalance() {
        return this.LoadBalance;
    }

    /**
     * Set LoadBalance information
     * @param LoadBalance LoadBalance information
     */
    public void setLoadBalance(String LoadBalance) {
        this.LoadBalance = LoadBalance;
    }

    /**
     * Get Value of httpsUpstreamPort 
     * @return HttpsUpstreamPort Value of httpsUpstreamPort
     */
    public String getHttpsUpstreamPort() {
        return this.HttpsUpstreamPort;
    }

    /**
     * Set Value of httpsUpstreamPort
     * @param HttpsUpstreamPort Value of httpsUpstreamPort
     */
    public void setHttpsUpstreamPort(String HttpsUpstreamPort) {
        this.HttpsUpstreamPort = HttpsUpstreamPort;
    }

    /**
     * Get Port information 
     * @return Ports Port information
     */
    public PortItem [] getPorts() {
        return this.Ports;
    }

    /**
     * Set Port information
     * @param Ports Port information
     */
    public void setPorts(PortItem [] Ports) {
        this.Ports = Ports;
    }

    /**
     * Get Whether it is grayscale 
     * @return IsGray Whether it is grayscale
     */
    public String getIsGray() {
        return this.IsGray;
    }

    /**
     * Set Whether it is grayscale
     * @param IsGray Whether it is grayscale
     */
    public void setIsGray(String IsGray) {
        this.IsGray = IsGray;
    }

    /**
     * Get Mode 
     * @return Mode Mode
     */
    public String getMode() {
        return this.Mode;
    }

    /**
     * Set Mode
     * @param Mode Mode
     */
    public void setMode(String Mode) {
        this.Mode = Mode;
    }

    /**
     * Get Defense level: 100, 200, 300 
     * @return Level Defense level: 100, 200, 300
     */
    public String getLevel() {
        return this.Level;
    }

    /**
     * Set Defense level: 100, 200, 300
     * @param Level Defense level: 100, 200, 300
     */
    public void setLevel(String Level) {
        this.Level = Level;
    }

    /**
     * Get Whether to maintain a long connection with the origin server 
     * @return IsKeepAlive Whether to maintain a long connection with the origin server
     */
    public String getIsKeepAlive() {
        return this.IsKeepAlive;
    }

    /**
     * Set Whether to maintain a long connection with the origin server
     * @param IsKeepAlive Whether to maintain a long connection with the origin server
     */
    public void setIsKeepAlive(String IsKeepAlive) {
        this.IsKeepAlive = IsKeepAlive;
    }

    /**
     * Get 0: BGP; 1: Anycast.
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Anycast 0: BGP; 1: Anycast.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getAnycast() {
        return this.Anycast;
    }

    /**
     * Set 0: BGP; 1: Anycast.
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Anycast 0: BGP; 1: Anycast.
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setAnycast(String Anycast) {
        this.Anycast = Anycast;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeSpartaProtectionInfoResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeSpartaProtectionInfoResponse(DescribeSpartaProtectionInfoResponse source) {
        if (source.Domain != null) {
            this.Domain = new String(source.Domain);
        }
        if (source.DomainId != null) {
            this.DomainId = new String(source.DomainId);
        }
        if (source.Cname != null) {
            this.Cname = new String(source.Cname);
        }
        if (source.Status != null) {
            this.Status = new String(source.Status);
        }
        if (source.SrcList != null) {
            this.SrcList = new String[source.SrcList.length];
            for (int i = 0; i < source.SrcList.length; i++) {
                this.SrcList[i] = new String(source.SrcList[i]);
            }
        }
        if (source.CertType != null) {
            this.CertType = new String(source.CertType);
        }
        if (source.Cert != null) {
            this.Cert = new String(source.Cert);
        }
        if (source.PrivateKey != null) {
            this.PrivateKey = new String(source.PrivateKey);
        }
        if (source.Sslid != null) {
            this.Sslid = new String(source.Sslid);
        }
        if (source.IsCdn != null) {
            this.IsCdn = new String(source.IsCdn);
        }
        if (source.GrayAreas != null) {
            this.GrayAreas = new String[source.GrayAreas.length];
            for (int i = 0; i < source.GrayAreas.length; i++) {
                this.GrayAreas[i] = new String(source.GrayAreas[i]);
            }
        }
        if (source.Engine != null) {
            this.Engine = new String(source.Engine);
        }
        if (source.HttpsRewrite != null) {
            this.HttpsRewrite = new String(source.HttpsRewrite);
        }
        if (source.UpstreamType != null) {
            this.UpstreamType = new String(source.UpstreamType);
        }
        if (source.UpstreamDomain != null) {
            this.UpstreamDomain = new String(source.UpstreamDomain);
        }
        if (source.UpstreamScheme != null) {
            this.UpstreamScheme = new String(source.UpstreamScheme);
        }
        if (source.IsHttp2 != null) {
            this.IsHttp2 = new String(source.IsHttp2);
        }
        if (source.IsWebsocket != null) {
            this.IsWebsocket = new String(source.IsWebsocket);
        }
        if (source.LoadBalance != null) {
            this.LoadBalance = new String(source.LoadBalance);
        }
        if (source.HttpsUpstreamPort != null) {
            this.HttpsUpstreamPort = new String(source.HttpsUpstreamPort);
        }
        if (source.Ports != null) {
            this.Ports = new PortItem[source.Ports.length];
            for (int i = 0; i < source.Ports.length; i++) {
                this.Ports[i] = new PortItem(source.Ports[i]);
            }
        }
        if (source.IsGray != null) {
            this.IsGray = new String(source.IsGray);
        }
        if (source.Mode != null) {
            this.Mode = new String(source.Mode);
        }
        if (source.Level != null) {
            this.Level = new String(source.Level);
        }
        if (source.IsKeepAlive != null) {
            this.IsKeepAlive = new String(source.IsKeepAlive);
        }
        if (source.Anycast != null) {
            this.Anycast = new String(source.Anycast);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Domain", this.Domain);
        this.setParamSimple(map, prefix + "DomainId", this.DomainId);
        this.setParamSimple(map, prefix + "Cname", this.Cname);
        this.setParamSimple(map, prefix + "Status", this.Status);
        this.setParamArraySimple(map, prefix + "SrcList.", this.SrcList);
        this.setParamSimple(map, prefix + "CertType", this.CertType);
        this.setParamSimple(map, prefix + "Cert", this.Cert);
        this.setParamSimple(map, prefix + "PrivateKey", this.PrivateKey);
        this.setParamSimple(map, prefix + "Sslid", this.Sslid);
        this.setParamSimple(map, prefix + "IsCdn", this.IsCdn);
        this.setParamArraySimple(map, prefix + "GrayAreas.", this.GrayAreas);
        this.setParamSimple(map, prefix + "Engine", this.Engine);
        this.setParamSimple(map, prefix + "HttpsRewrite", this.HttpsRewrite);
        this.setParamSimple(map, prefix + "UpstreamType", this.UpstreamType);
        this.setParamSimple(map, prefix + "UpstreamDomain", this.UpstreamDomain);
        this.setParamSimple(map, prefix + "UpstreamScheme", this.UpstreamScheme);
        this.setParamSimple(map, prefix + "IsHttp2", this.IsHttp2);
        this.setParamSimple(map, prefix + "IsWebsocket", this.IsWebsocket);
        this.setParamSimple(map, prefix + "LoadBalance", this.LoadBalance);
        this.setParamSimple(map, prefix + "HttpsUpstreamPort", this.HttpsUpstreamPort);
        this.setParamArrayObj(map, prefix + "Ports.", this.Ports);
        this.setParamSimple(map, prefix + "IsGray", this.IsGray);
        this.setParamSimple(map, prefix + "Mode", this.Mode);
        this.setParamSimple(map, prefix + "Level", this.Level);
        this.setParamSimple(map, prefix + "IsKeepAlive", this.IsKeepAlive);
        this.setParamSimple(map, prefix + "Anycast", this.Anycast);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

