/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.waf.v20180125.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeTopAttackDomainResponse extends AbstractModel {

    /**
    * CC attack domain list
    */
    @SerializedName("CC")
    @Expose
    private KVInt [] CC;

    /**
    * Web attack domain list
    */
    @SerializedName("Web")
    @Expose
    private KVInt [] Web;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get CC attack domain list 
     * @return CC CC attack domain list
     */
    public KVInt [] getCC() {
        return this.CC;
    }

    /**
     * Set CC attack domain list
     * @param CC CC attack domain list
     */
    public void setCC(KVInt [] CC) {
        this.CC = CC;
    }

    /**
     * Get Web attack domain list 
     * @return Web Web attack domain list
     */
    public KVInt [] getWeb() {
        return this.Web;
    }

    /**
     * Set Web attack domain list
     * @param Web Web attack domain list
     */
    public void setWeb(KVInt [] Web) {
        this.Web = Web;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeTopAttackDomainResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeTopAttackDomainResponse(DescribeTopAttackDomainResponse source) {
        if (source.CC != null) {
            this.CC = new KVInt[source.CC.length];
            for (int i = 0; i < source.CC.length; i++) {
                this.CC[i] = new KVInt(source.CC[i]);
            }
        }
        if (source.Web != null) {
            this.Web = new KVInt[source.Web.length];
            for (int i = 0; i < source.Web.length; i++) {
                this.Web[i] = new KVInt(source.Web[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "CC.", this.CC);
        this.setParamArrayObj(map, prefix + "Web.", this.Web);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

