/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.waf.v20180125.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeUserClbWafRegionsResponse extends AbstractModel {

    /**
    * Region (in standard ap-format) list

Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Data")
    @Expose
    private String [] Data;

    /**
    * Geographical information with detailed attributes

Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("RichDatas")
    @Expose
    private ClbWafRegionItem [] RichDatas;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Region (in standard ap-format) list

Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Data Region (in standard ap-format) list

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String [] getData() {
        return this.Data;
    }

    /**
     * Set Region (in standard ap-format) list

Note: This field may return null, indicating that no valid values can be obtained.
     * @param Data Region (in standard ap-format) list

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setData(String [] Data) {
        this.Data = Data;
    }

    /**
     * Get Geographical information with detailed attributes

Note: This field may return null, indicating that no valid values can be obtained. 
     * @return RichDatas Geographical information with detailed attributes

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public ClbWafRegionItem [] getRichDatas() {
        return this.RichDatas;
    }

    /**
     * Set Geographical information with detailed attributes

Note: This field may return null, indicating that no valid values can be obtained.
     * @param RichDatas Geographical information with detailed attributes

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setRichDatas(ClbWafRegionItem [] RichDatas) {
        this.RichDatas = RichDatas;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeUserClbWafRegionsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeUserClbWafRegionsResponse(DescribeUserClbWafRegionsResponse source) {
        if (source.Data != null) {
            this.Data = new String[source.Data.length];
            for (int i = 0; i < source.Data.length; i++) {
                this.Data[i] = new String(source.Data[i]);
            }
        }
        if (source.RichDatas != null) {
            this.RichDatas = new ClbWafRegionItem[source.RichDatas.length];
            for (int i = 0; i < source.RichDatas.length; i++) {
                this.RichDatas[i] = new ClbWafRegionItem(source.RichDatas[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArraySimple(map, prefix + "Data.", this.Data);
        this.setParamArrayObj(map, prefix + "RichDatas.", this.RichDatas);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

