/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.waf.v20180125.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class SearchAttackLogResponse extends AbstractModel {

    /**
    * Number of attack logs returned
    */
    @SerializedName("Count")
    @Expose
    private Long Count;

    /**
    * API upgrade: this field is invalid, defaults to returning an empty string
    */
    @SerializedName("Context")
    @Expose
    private String Context;

    /**
    * Attack log array entry content
    */
    @SerializedName("Data")
    @Expose
    private AttackLogInfo [] Data;

    /**
    * CLS API returned content
    */
    @SerializedName("ListOver")
    @Expose
    private Boolean ListOver;

    /**
    * CLS API returned content, indicating whether to enable the new version index
    */
    @SerializedName("SqlFlag")
    @Expose
    private Boolean SqlFlag;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Number of attack logs returned 
     * @return Count Number of attack logs returned
     */
    public Long getCount() {
        return this.Count;
    }

    /**
     * Set Number of attack logs returned
     * @param Count Number of attack logs returned
     */
    public void setCount(Long Count) {
        this.Count = Count;
    }

    /**
     * Get API upgrade: this field is invalid, defaults to returning an empty string 
     * @return Context API upgrade: this field is invalid, defaults to returning an empty string
     */
    public String getContext() {
        return this.Context;
    }

    /**
     * Set API upgrade: this field is invalid, defaults to returning an empty string
     * @param Context API upgrade: this field is invalid, defaults to returning an empty string
     */
    public void setContext(String Context) {
        this.Context = Context;
    }

    /**
     * Get Attack log array entry content 
     * @return Data Attack log array entry content
     */
    public AttackLogInfo [] getData() {
        return this.Data;
    }

    /**
     * Set Attack log array entry content
     * @param Data Attack log array entry content
     */
    public void setData(AttackLogInfo [] Data) {
        this.Data = Data;
    }

    /**
     * Get CLS API returned content 
     * @return ListOver CLS API returned content
     */
    public Boolean getListOver() {
        return this.ListOver;
    }

    /**
     * Set CLS API returned content
     * @param ListOver CLS API returned content
     */
    public void setListOver(Boolean ListOver) {
        this.ListOver = ListOver;
    }

    /**
     * Get CLS API returned content, indicating whether to enable the new version index 
     * @return SqlFlag CLS API returned content, indicating whether to enable the new version index
     */
    public Boolean getSqlFlag() {
        return this.SqlFlag;
    }

    /**
     * Set CLS API returned content, indicating whether to enable the new version index
     * @param SqlFlag CLS API returned content, indicating whether to enable the new version index
     */
    public void setSqlFlag(Boolean SqlFlag) {
        this.SqlFlag = SqlFlag;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public SearchAttackLogResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public SearchAttackLogResponse(SearchAttackLogResponse source) {
        if (source.Count != null) {
            this.Count = new Long(source.Count);
        }
        if (source.Context != null) {
            this.Context = new String(source.Context);
        }
        if (source.Data != null) {
            this.Data = new AttackLogInfo[source.Data.length];
            for (int i = 0; i < source.Data.length; i++) {
                this.Data[i] = new AttackLogInfo(source.Data[i]);
            }
        }
        if (source.ListOver != null) {
            this.ListOver = new Boolean(source.ListOver);
        }
        if (source.SqlFlag != null) {
            this.SqlFlag = new Boolean(source.SqlFlag);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Count", this.Count);
        this.setParamSimple(map, prefix + "Context", this.Context);
        this.setParamArrayObj(map, prefix + "Data.", this.Data);
        this.setParamSimple(map, prefix + "ListOver", this.ListOver);
        this.setParamSimple(map, prefix + "SqlFlag", this.SqlFlag);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

