/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.waf.v20180125.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class UpsertSessionResponse extends AbstractModel {

    /**
    * Result
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Data")
    @Expose
    private String Data;

    /**
    * SessionID
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("SessionID")
    @Expose
    private Long SessionID;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Result
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Data Result
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getData() {
        return this.Data;
    }

    /**
     * Set Result
Note: This field may return null, indicating that no valid values can be obtained.
     * @param Data Result
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setData(String Data) {
        this.Data = Data;
    }

    /**
     * Get SessionID
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return SessionID SessionID
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Long getSessionID() {
        return this.SessionID;
    }

    /**
     * Set SessionID
Note: This field may return null, indicating that no valid values can be obtained.
     * @param SessionID SessionID
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setSessionID(Long SessionID) {
        this.SessionID = SessionID;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public UpsertSessionResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public UpsertSessionResponse(UpsertSessionResponse source) {
        if (source.Data != null) {
            this.Data = new String(source.Data);
        }
        if (source.SessionID != null) {
            this.SessionID = new Long(source.SessionID);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Data", this.Data);
        this.setParamSimple(map, prefix + "SessionID", this.SessionID);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

