/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.wedata.v20210820.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class CheckTaskNameExistRequest extends AbstractModel {

    /**
    * Project ID/Workspace ID.
    */
    @SerializedName("ProjectId")
    @Expose
    private String ProjectId;

    /**
    * Task Type (consistent with scheduling parameters).
    */
    @SerializedName("TypeId")
    @Expose
    private Long TypeId;

    /**
    * Task Name.
    */
    @SerializedName("TaskName")
    @Expose
    private String TaskName;

    /**
     * Get Project ID/Workspace ID. 
     * @return ProjectId Project ID/Workspace ID.
     */
    public String getProjectId() {
        return this.ProjectId;
    }

    /**
     * Set Project ID/Workspace ID.
     * @param ProjectId Project ID/Workspace ID.
     */
    public void setProjectId(String ProjectId) {
        this.ProjectId = ProjectId;
    }

    /**
     * Get Task Type (consistent with scheduling parameters). 
     * @return TypeId Task Type (consistent with scheduling parameters).
     */
    public Long getTypeId() {
        return this.TypeId;
    }

    /**
     * Set Task Type (consistent with scheduling parameters).
     * @param TypeId Task Type (consistent with scheduling parameters).
     */
    public void setTypeId(Long TypeId) {
        this.TypeId = TypeId;
    }

    /**
     * Get Task Name. 
     * @return TaskName Task Name.
     */
    public String getTaskName() {
        return this.TaskName;
    }

    /**
     * Set Task Name.
     * @param TaskName Task Name.
     */
    public void setTaskName(String TaskName) {
        this.TaskName = TaskName;
    }

    public CheckTaskNameExistRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public CheckTaskNameExistRequest(CheckTaskNameExistRequest source) {
        if (source.ProjectId != null) {
            this.ProjectId = new String(source.ProjectId);
        }
        if (source.TypeId != null) {
            this.TypeId = new Long(source.TypeId);
        }
        if (source.TaskName != null) {
            this.TaskName = new String(source.TaskName);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ProjectId", this.ProjectId);
        this.setParamSimple(map, prefix + "TypeId", this.TypeId);
        this.setParamSimple(map, prefix + "TaskName", this.TaskName);

    }
}

