/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.wedata.v20210820.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeIntegrationNodeResponse extends AbstractModel {

    /**
    * Node information\nNote: This field may return null, indicating that no valid value can be obtained.
    */
    @SerializedName("NodeInfo")
    @Expose
    private IntegrationNodeInfo NodeInfo;

    /**
    * Has the upstream node been modified? true Modified, needs to be prompted; false Not modified\nNote: This field may return null, indicating that no valid value can be obtained.
    */
    @SerializedName("SourceCheckFlag")
    @Expose
    private Boolean SourceCheckFlag;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Node information\nNote: This field may return null, indicating that no valid value can be obtained. 
     * @return NodeInfo Node information\nNote: This field may return null, indicating that no valid value can be obtained.
     */
    public IntegrationNodeInfo getNodeInfo() {
        return this.NodeInfo;
    }

    /**
     * Set Node information\nNote: This field may return null, indicating that no valid value can be obtained.
     * @param NodeInfo Node information\nNote: This field may return null, indicating that no valid value can be obtained.
     */
    public void setNodeInfo(IntegrationNodeInfo NodeInfo) {
        this.NodeInfo = NodeInfo;
    }

    /**
     * Get Has the upstream node been modified? true Modified, needs to be prompted; false Not modified\nNote: This field may return null, indicating that no valid value can be obtained. 
     * @return SourceCheckFlag Has the upstream node been modified? true Modified, needs to be prompted; false Not modified\nNote: This field may return null, indicating that no valid value can be obtained.
     */
    public Boolean getSourceCheckFlag() {
        return this.SourceCheckFlag;
    }

    /**
     * Set Has the upstream node been modified? true Modified, needs to be prompted; false Not modified\nNote: This field may return null, indicating that no valid value can be obtained.
     * @param SourceCheckFlag Has the upstream node been modified? true Modified, needs to be prompted; false Not modified\nNote: This field may return null, indicating that no valid value can be obtained.
     */
    public void setSourceCheckFlag(Boolean SourceCheckFlag) {
        this.SourceCheckFlag = SourceCheckFlag;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeIntegrationNodeResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeIntegrationNodeResponse(DescribeIntegrationNodeResponse source) {
        if (source.NodeInfo != null) {
            this.NodeInfo = new IntegrationNodeInfo(source.NodeInfo);
        }
        if (source.SourceCheckFlag != null) {
            this.SourceCheckFlag = new Boolean(source.SourceCheckFlag);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamObj(map, prefix + "NodeInfo.", this.NodeInfo);
        this.setParamSimple(map, prefix + "SourceCheckFlag", this.SourceCheckFlag);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

