/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.wedata.v20210820.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeIntegrationStatisticsResponse extends AbstractModel {

    /**
    * Total Tasks
Note: This field may return null, indicating that no valid value can be obtained.
    */
    @SerializedName("TotalTask")
    @Expose
    private Long TotalTask;

    /**
    * Number of Production Tasks
Note: This field may return null, indicating that no valid value can be obtained.
    */
    @SerializedName("ProdTask")
    @Expose
    private Long ProdTask;

    /**
    * Number of Development Tasks
Note: This field may return null, indicating that no valid value can be obtained.
    */
    @SerializedName("DevTask")
    @Expose
    private Long DevTask;

    /**
    * Total Number of Reads
Note: This field may return null, indicating that no valid value can be obtained.
    */
    @SerializedName("TotalReadRecords")
    @Expose
    private Long TotalReadRecords;

    /**
    * Total Number of Writes
Note: This field may return null, indicating that no valid value can be obtained.
    */
    @SerializedName("TotalWriteRecords")
    @Expose
    private Long TotalWriteRecords;

    /**
    * Total Number of Dirty Data Entries
Note: This field may return null, indicating that no valid value can be obtained.
    */
    @SerializedName("TotalErrorRecords")
    @Expose
    private Long TotalErrorRecords;

    /**
    * Total Number of Alarm Events
Note: This field may return null, indicating that no valid value can be obtained.
    */
    @SerializedName("TotalAlarmEvent")
    @Expose
    private Long TotalAlarmEvent;

    /**
    * Daily Increase in Reads
Note: This field may return null, indicating that no valid value can be obtained.
    */
    @SerializedName("IncreaseReadRecords")
    @Expose
    private Long IncreaseReadRecords;

    /**
    * Daily Increase in Writes
Note: This field may return null, indicating that no valid value can be obtained.
    */
    @SerializedName("IncreaseWriteRecords")
    @Expose
    private Long IncreaseWriteRecords;

    /**
    * Daily Increase in Dirty Data Entries
Note: This field may return null, indicating that no valid value can be obtained.
    */
    @SerializedName("IncreaseErrorRecords")
    @Expose
    private Long IncreaseErrorRecords;

    /**
    * Daily Increase in Alarm Events
Note: This field may return null, indicating that no valid value can be obtained.
    */
    @SerializedName("IncreaseAlarmEvent")
    @Expose
    private Long IncreaseAlarmEvent;

    /**
    * Alarm Event Statistics
Note: This field may return null, indicating that no valid value can be obtained.
    */
    @SerializedName("AlarmEvent")
    @Expose
    private String AlarmEvent;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total Tasks
Note: This field may return null, indicating that no valid value can be obtained. 
     * @return TotalTask Total Tasks
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public Long getTotalTask() {
        return this.TotalTask;
    }

    /**
     * Set Total Tasks
Note: This field may return null, indicating that no valid value can be obtained.
     * @param TotalTask Total Tasks
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public void setTotalTask(Long TotalTask) {
        this.TotalTask = TotalTask;
    }

    /**
     * Get Number of Production Tasks
Note: This field may return null, indicating that no valid value can be obtained. 
     * @return ProdTask Number of Production Tasks
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public Long getProdTask() {
        return this.ProdTask;
    }

    /**
     * Set Number of Production Tasks
Note: This field may return null, indicating that no valid value can be obtained.
     * @param ProdTask Number of Production Tasks
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public void setProdTask(Long ProdTask) {
        this.ProdTask = ProdTask;
    }

    /**
     * Get Number of Development Tasks
Note: This field may return null, indicating that no valid value can be obtained. 
     * @return DevTask Number of Development Tasks
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public Long getDevTask() {
        return this.DevTask;
    }

    /**
     * Set Number of Development Tasks
Note: This field may return null, indicating that no valid value can be obtained.
     * @param DevTask Number of Development Tasks
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public void setDevTask(Long DevTask) {
        this.DevTask = DevTask;
    }

    /**
     * Get Total Number of Reads
Note: This field may return null, indicating that no valid value can be obtained. 
     * @return TotalReadRecords Total Number of Reads
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public Long getTotalReadRecords() {
        return this.TotalReadRecords;
    }

    /**
     * Set Total Number of Reads
Note: This field may return null, indicating that no valid value can be obtained.
     * @param TotalReadRecords Total Number of Reads
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public void setTotalReadRecords(Long TotalReadRecords) {
        this.TotalReadRecords = TotalReadRecords;
    }

    /**
     * Get Total Number of Writes
Note: This field may return null, indicating that no valid value can be obtained. 
     * @return TotalWriteRecords Total Number of Writes
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public Long getTotalWriteRecords() {
        return this.TotalWriteRecords;
    }

    /**
     * Set Total Number of Writes
Note: This field may return null, indicating that no valid value can be obtained.
     * @param TotalWriteRecords Total Number of Writes
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public void setTotalWriteRecords(Long TotalWriteRecords) {
        this.TotalWriteRecords = TotalWriteRecords;
    }

    /**
     * Get Total Number of Dirty Data Entries
Note: This field may return null, indicating that no valid value can be obtained. 
     * @return TotalErrorRecords Total Number of Dirty Data Entries
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public Long getTotalErrorRecords() {
        return this.TotalErrorRecords;
    }

    /**
     * Set Total Number of Dirty Data Entries
Note: This field may return null, indicating that no valid value can be obtained.
     * @param TotalErrorRecords Total Number of Dirty Data Entries
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public void setTotalErrorRecords(Long TotalErrorRecords) {
        this.TotalErrorRecords = TotalErrorRecords;
    }

    /**
     * Get Total Number of Alarm Events
Note: This field may return null, indicating that no valid value can be obtained. 
     * @return TotalAlarmEvent Total Number of Alarm Events
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public Long getTotalAlarmEvent() {
        return this.TotalAlarmEvent;
    }

    /**
     * Set Total Number of Alarm Events
Note: This field may return null, indicating that no valid value can be obtained.
     * @param TotalAlarmEvent Total Number of Alarm Events
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public void setTotalAlarmEvent(Long TotalAlarmEvent) {
        this.TotalAlarmEvent = TotalAlarmEvent;
    }

    /**
     * Get Daily Increase in Reads
Note: This field may return null, indicating that no valid value can be obtained. 
     * @return IncreaseReadRecords Daily Increase in Reads
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public Long getIncreaseReadRecords() {
        return this.IncreaseReadRecords;
    }

    /**
     * Set Daily Increase in Reads
Note: This field may return null, indicating that no valid value can be obtained.
     * @param IncreaseReadRecords Daily Increase in Reads
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public void setIncreaseReadRecords(Long IncreaseReadRecords) {
        this.IncreaseReadRecords = IncreaseReadRecords;
    }

    /**
     * Get Daily Increase in Writes
Note: This field may return null, indicating that no valid value can be obtained. 
     * @return IncreaseWriteRecords Daily Increase in Writes
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public Long getIncreaseWriteRecords() {
        return this.IncreaseWriteRecords;
    }

    /**
     * Set Daily Increase in Writes
Note: This field may return null, indicating that no valid value can be obtained.
     * @param IncreaseWriteRecords Daily Increase in Writes
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public void setIncreaseWriteRecords(Long IncreaseWriteRecords) {
        this.IncreaseWriteRecords = IncreaseWriteRecords;
    }

    /**
     * Get Daily Increase in Dirty Data Entries
Note: This field may return null, indicating that no valid value can be obtained. 
     * @return IncreaseErrorRecords Daily Increase in Dirty Data Entries
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public Long getIncreaseErrorRecords() {
        return this.IncreaseErrorRecords;
    }

    /**
     * Set Daily Increase in Dirty Data Entries
Note: This field may return null, indicating that no valid value can be obtained.
     * @param IncreaseErrorRecords Daily Increase in Dirty Data Entries
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public void setIncreaseErrorRecords(Long IncreaseErrorRecords) {
        this.IncreaseErrorRecords = IncreaseErrorRecords;
    }

    /**
     * Get Daily Increase in Alarm Events
Note: This field may return null, indicating that no valid value can be obtained. 
     * @return IncreaseAlarmEvent Daily Increase in Alarm Events
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public Long getIncreaseAlarmEvent() {
        return this.IncreaseAlarmEvent;
    }

    /**
     * Set Daily Increase in Alarm Events
Note: This field may return null, indicating that no valid value can be obtained.
     * @param IncreaseAlarmEvent Daily Increase in Alarm Events
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public void setIncreaseAlarmEvent(Long IncreaseAlarmEvent) {
        this.IncreaseAlarmEvent = IncreaseAlarmEvent;
    }

    /**
     * Get Alarm Event Statistics
Note: This field may return null, indicating that no valid value can be obtained. 
     * @return AlarmEvent Alarm Event Statistics
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public String getAlarmEvent() {
        return this.AlarmEvent;
    }

    /**
     * Set Alarm Event Statistics
Note: This field may return null, indicating that no valid value can be obtained.
     * @param AlarmEvent Alarm Event Statistics
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public void setAlarmEvent(String AlarmEvent) {
        this.AlarmEvent = AlarmEvent;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeIntegrationStatisticsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeIntegrationStatisticsResponse(DescribeIntegrationStatisticsResponse source) {
        if (source.TotalTask != null) {
            this.TotalTask = new Long(source.TotalTask);
        }
        if (source.ProdTask != null) {
            this.ProdTask = new Long(source.ProdTask);
        }
        if (source.DevTask != null) {
            this.DevTask = new Long(source.DevTask);
        }
        if (source.TotalReadRecords != null) {
            this.TotalReadRecords = new Long(source.TotalReadRecords);
        }
        if (source.TotalWriteRecords != null) {
            this.TotalWriteRecords = new Long(source.TotalWriteRecords);
        }
        if (source.TotalErrorRecords != null) {
            this.TotalErrorRecords = new Long(source.TotalErrorRecords);
        }
        if (source.TotalAlarmEvent != null) {
            this.TotalAlarmEvent = new Long(source.TotalAlarmEvent);
        }
        if (source.IncreaseReadRecords != null) {
            this.IncreaseReadRecords = new Long(source.IncreaseReadRecords);
        }
        if (source.IncreaseWriteRecords != null) {
            this.IncreaseWriteRecords = new Long(source.IncreaseWriteRecords);
        }
        if (source.IncreaseErrorRecords != null) {
            this.IncreaseErrorRecords = new Long(source.IncreaseErrorRecords);
        }
        if (source.IncreaseAlarmEvent != null) {
            this.IncreaseAlarmEvent = new Long(source.IncreaseAlarmEvent);
        }
        if (source.AlarmEvent != null) {
            this.AlarmEvent = new String(source.AlarmEvent);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalTask", this.TotalTask);
        this.setParamSimple(map, prefix + "ProdTask", this.ProdTask);
        this.setParamSimple(map, prefix + "DevTask", this.DevTask);
        this.setParamSimple(map, prefix + "TotalReadRecords", this.TotalReadRecords);
        this.setParamSimple(map, prefix + "TotalWriteRecords", this.TotalWriteRecords);
        this.setParamSimple(map, prefix + "TotalErrorRecords", this.TotalErrorRecords);
        this.setParamSimple(map, prefix + "TotalAlarmEvent", this.TotalAlarmEvent);
        this.setParamSimple(map, prefix + "IncreaseReadRecords", this.IncreaseReadRecords);
        this.setParamSimple(map, prefix + "IncreaseWriteRecords", this.IncreaseWriteRecords);
        this.setParamSimple(map, prefix + "IncreaseErrorRecords", this.IncreaseErrorRecords);
        this.setParamSimple(map, prefix + "IncreaseAlarmEvent", this.IncreaseAlarmEvent);
        this.setParamSimple(map, prefix + "AlarmEvent", this.AlarmEvent);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

