/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.wedata.v20210820.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeIntegrationVersionNodesInfoResponse extends AbstractModel {

    /**
    * Task Node Information
Note: This field may return null, indicating that no valid value can be obtained.
    */
    @SerializedName("Nodes")
    @Expose
    private IntegrationNodeInfo [] Nodes;

    /**
    * Task Mapping Information
Note: This field may return null, indicating that no valid value can be obtained.
    */
    @SerializedName("Mappings")
    @Expose
    private IntegrationNodeMapping [] Mappings;

    /**
    * Task ID
    */
    @SerializedName("TaskId")
    @Expose
    private String TaskId;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Task Node Information
Note: This field may return null, indicating that no valid value can be obtained. 
     * @return Nodes Task Node Information
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public IntegrationNodeInfo [] getNodes() {
        return this.Nodes;
    }

    /**
     * Set Task Node Information
Note: This field may return null, indicating that no valid value can be obtained.
     * @param Nodes Task Node Information
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public void setNodes(IntegrationNodeInfo [] Nodes) {
        this.Nodes = Nodes;
    }

    /**
     * Get Task Mapping Information
Note: This field may return null, indicating that no valid value can be obtained. 
     * @return Mappings Task Mapping Information
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public IntegrationNodeMapping [] getMappings() {
        return this.Mappings;
    }

    /**
     * Set Task Mapping Information
Note: This field may return null, indicating that no valid value can be obtained.
     * @param Mappings Task Mapping Information
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public void setMappings(IntegrationNodeMapping [] Mappings) {
        this.Mappings = Mappings;
    }

    /**
     * Get Task ID 
     * @return TaskId Task ID
     */
    public String getTaskId() {
        return this.TaskId;
    }

    /**
     * Set Task ID
     * @param TaskId Task ID
     */
    public void setTaskId(String TaskId) {
        this.TaskId = TaskId;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeIntegrationVersionNodesInfoResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeIntegrationVersionNodesInfoResponse(DescribeIntegrationVersionNodesInfoResponse source) {
        if (source.Nodes != null) {
            this.Nodes = new IntegrationNodeInfo[source.Nodes.length];
            for (int i = 0; i < source.Nodes.length; i++) {
                this.Nodes[i] = new IntegrationNodeInfo(source.Nodes[i]);
            }
        }
        if (source.Mappings != null) {
            this.Mappings = new IntegrationNodeMapping[source.Mappings.length];
            for (int i = 0; i < source.Mappings.length; i++) {
                this.Mappings[i] = new IntegrationNodeMapping(source.Mappings[i]);
            }
        }
        if (source.TaskId != null) {
            this.TaskId = new String(source.TaskId);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "Nodes.", this.Nodes);
        this.setParamArrayObj(map, prefix + "Mappings.", this.Mappings);
        this.setParamSimple(map, prefix + "TaskId", this.TaskId);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

