/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.wedata.v20210820.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeRealTimeTaskMetricOverviewResponse extends AbstractModel {

    /**
    * Total Read Records
    */
    @SerializedName("TotalRecordNumOfRead")
    @Expose
    private Long TotalRecordNumOfRead;

    /**
    * Total Read Bytes
    */
    @SerializedName("TotalRecordByteNumOfRead")
    @Expose
    private Long TotalRecordByteNumOfRead;

    /**
    * Total Write Records
    */
    @SerializedName("TotalRecordNumOfWrite")
    @Expose
    private Long TotalRecordNumOfWrite;

    /**
    * Total Write Bytes Unit: bytes
    */
    @SerializedName("TotalRecordByteNumOfWrite")
    @Expose
    private Long TotalRecordByteNumOfWrite;

    /**
    * Total Dirty Record Data
    */
    @SerializedName("TotalDirtyRecordNum")
    @Expose
    private Long TotalDirtyRecordNum;

    /**
    * Total Dirty Bytes Unit: bytes
    */
    @SerializedName("TotalDirtyRecordByte")
    @Expose
    private Long TotalDirtyRecordByte;

    /**
    * Execution Duration Unit: s
    */
    @SerializedName("TotalDuration")
    @Expose
    private Long TotalDuration;

    /**
    * Start Running Time
    */
    @SerializedName("BeginRunTime")
    @Expose
    private String BeginRunTime;

    /**
    * Current Running Time
    */
    @SerializedName("EndRunTime")
    @Expose
    private String EndRunTime;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Total Read Records 
     * @return TotalRecordNumOfRead Total Read Records
     */
    public Long getTotalRecordNumOfRead() {
        return this.TotalRecordNumOfRead;
    }

    /**
     * Set Total Read Records
     * @param TotalRecordNumOfRead Total Read Records
     */
    public void setTotalRecordNumOfRead(Long TotalRecordNumOfRead) {
        this.TotalRecordNumOfRead = TotalRecordNumOfRead;
    }

    /**
     * Get Total Read Bytes 
     * @return TotalRecordByteNumOfRead Total Read Bytes
     */
    public Long getTotalRecordByteNumOfRead() {
        return this.TotalRecordByteNumOfRead;
    }

    /**
     * Set Total Read Bytes
     * @param TotalRecordByteNumOfRead Total Read Bytes
     */
    public void setTotalRecordByteNumOfRead(Long TotalRecordByteNumOfRead) {
        this.TotalRecordByteNumOfRead = TotalRecordByteNumOfRead;
    }

    /**
     * Get Total Write Records 
     * @return TotalRecordNumOfWrite Total Write Records
     */
    public Long getTotalRecordNumOfWrite() {
        return this.TotalRecordNumOfWrite;
    }

    /**
     * Set Total Write Records
     * @param TotalRecordNumOfWrite Total Write Records
     */
    public void setTotalRecordNumOfWrite(Long TotalRecordNumOfWrite) {
        this.TotalRecordNumOfWrite = TotalRecordNumOfWrite;
    }

    /**
     * Get Total Write Bytes Unit: bytes 
     * @return TotalRecordByteNumOfWrite Total Write Bytes Unit: bytes
     */
    public Long getTotalRecordByteNumOfWrite() {
        return this.TotalRecordByteNumOfWrite;
    }

    /**
     * Set Total Write Bytes Unit: bytes
     * @param TotalRecordByteNumOfWrite Total Write Bytes Unit: bytes
     */
    public void setTotalRecordByteNumOfWrite(Long TotalRecordByteNumOfWrite) {
        this.TotalRecordByteNumOfWrite = TotalRecordByteNumOfWrite;
    }

    /**
     * Get Total Dirty Record Data 
     * @return TotalDirtyRecordNum Total Dirty Record Data
     */
    public Long getTotalDirtyRecordNum() {
        return this.TotalDirtyRecordNum;
    }

    /**
     * Set Total Dirty Record Data
     * @param TotalDirtyRecordNum Total Dirty Record Data
     */
    public void setTotalDirtyRecordNum(Long TotalDirtyRecordNum) {
        this.TotalDirtyRecordNum = TotalDirtyRecordNum;
    }

    /**
     * Get Total Dirty Bytes Unit: bytes 
     * @return TotalDirtyRecordByte Total Dirty Bytes Unit: bytes
     */
    public Long getTotalDirtyRecordByte() {
        return this.TotalDirtyRecordByte;
    }

    /**
     * Set Total Dirty Bytes Unit: bytes
     * @param TotalDirtyRecordByte Total Dirty Bytes Unit: bytes
     */
    public void setTotalDirtyRecordByte(Long TotalDirtyRecordByte) {
        this.TotalDirtyRecordByte = TotalDirtyRecordByte;
    }

    /**
     * Get Execution Duration Unit: s 
     * @return TotalDuration Execution Duration Unit: s
     */
    public Long getTotalDuration() {
        return this.TotalDuration;
    }

    /**
     * Set Execution Duration Unit: s
     * @param TotalDuration Execution Duration Unit: s
     */
    public void setTotalDuration(Long TotalDuration) {
        this.TotalDuration = TotalDuration;
    }

    /**
     * Get Start Running Time 
     * @return BeginRunTime Start Running Time
     */
    public String getBeginRunTime() {
        return this.BeginRunTime;
    }

    /**
     * Set Start Running Time
     * @param BeginRunTime Start Running Time
     */
    public void setBeginRunTime(String BeginRunTime) {
        this.BeginRunTime = BeginRunTime;
    }

    /**
     * Get Current Running Time 
     * @return EndRunTime Current Running Time
     */
    public String getEndRunTime() {
        return this.EndRunTime;
    }

    /**
     * Set Current Running Time
     * @param EndRunTime Current Running Time
     */
    public void setEndRunTime(String EndRunTime) {
        this.EndRunTime = EndRunTime;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeRealTimeTaskMetricOverviewResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeRealTimeTaskMetricOverviewResponse(DescribeRealTimeTaskMetricOverviewResponse source) {
        if (source.TotalRecordNumOfRead != null) {
            this.TotalRecordNumOfRead = new Long(source.TotalRecordNumOfRead);
        }
        if (source.TotalRecordByteNumOfRead != null) {
            this.TotalRecordByteNumOfRead = new Long(source.TotalRecordByteNumOfRead);
        }
        if (source.TotalRecordNumOfWrite != null) {
            this.TotalRecordNumOfWrite = new Long(source.TotalRecordNumOfWrite);
        }
        if (source.TotalRecordByteNumOfWrite != null) {
            this.TotalRecordByteNumOfWrite = new Long(source.TotalRecordByteNumOfWrite);
        }
        if (source.TotalDirtyRecordNum != null) {
            this.TotalDirtyRecordNum = new Long(source.TotalDirtyRecordNum);
        }
        if (source.TotalDirtyRecordByte != null) {
            this.TotalDirtyRecordByte = new Long(source.TotalDirtyRecordByte);
        }
        if (source.TotalDuration != null) {
            this.TotalDuration = new Long(source.TotalDuration);
        }
        if (source.BeginRunTime != null) {
            this.BeginRunTime = new String(source.BeginRunTime);
        }
        if (source.EndRunTime != null) {
            this.EndRunTime = new String(source.EndRunTime);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TotalRecordNumOfRead", this.TotalRecordNumOfRead);
        this.setParamSimple(map, prefix + "TotalRecordByteNumOfRead", this.TotalRecordByteNumOfRead);
        this.setParamSimple(map, prefix + "TotalRecordNumOfWrite", this.TotalRecordNumOfWrite);
        this.setParamSimple(map, prefix + "TotalRecordByteNumOfWrite", this.TotalRecordByteNumOfWrite);
        this.setParamSimple(map, prefix + "TotalDirtyRecordNum", this.TotalDirtyRecordNum);
        this.setParamSimple(map, prefix + "TotalDirtyRecordByte", this.TotalDirtyRecordByte);
        this.setParamSimple(map, prefix + "TotalDuration", this.TotalDuration);
        this.setParamSimple(map, prefix + "BeginRunTime", this.BeginRunTime);
        this.setParamSimple(map, prefix + "EndRunTime", this.EndRunTime);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

