/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.wedata.v20210820.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeTableSchemaInfoResponse extends AbstractModel {

    /**
    * Retrieved SchemaInfo Information
Note: This field may return null, indicating that no valid value can be obtained.
    */
    @SerializedName("SchemaInfoList")
    @Expose
    private SchemaDetail [] SchemaInfoList;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Retrieved SchemaInfo Information
Note: This field may return null, indicating that no valid value can be obtained. 
     * @return SchemaInfoList Retrieved SchemaInfo Information
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public SchemaDetail [] getSchemaInfoList() {
        return this.SchemaInfoList;
    }

    /**
     * Set Retrieved SchemaInfo Information
Note: This field may return null, indicating that no valid value can be obtained.
     * @param SchemaInfoList Retrieved SchemaInfo Information
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public void setSchemaInfoList(SchemaDetail [] SchemaInfoList) {
        this.SchemaInfoList = SchemaInfoList;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeTableSchemaInfoResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeTableSchemaInfoResponse(DescribeTableSchemaInfoResponse source) {
        if (source.SchemaInfoList != null) {
            this.SchemaInfoList = new SchemaDetail[source.SchemaInfoList.length];
            for (int i = 0; i < source.SchemaInfoList.length; i++) {
                this.SchemaInfoList[i] = new SchemaDetail(source.SchemaInfoList[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "SchemaInfoList.", this.SchemaInfoList);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

