/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.wedata.v20210820.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class InstanceLogInfoOpsDto extends AbstractModel {

    /**
    * Instance running log
Note: This field may return null, indicating that no valid value can be obtained.
    */
    @SerializedName("LogInfo")
    @Expose
    private String LogInfo;

    /**
    * The Yarn log address submitted by the instance run
Note: This field may return null, indicating that no valid value can be obtained.
    */
    @SerializedName("YarnLogInfo")
    @Expose
    private String [] YarnLogInfo;

    /**
    * The datax log generated by the instance run
Note: This field may return null, indicating that no valid value can be obtained.
    */
    @SerializedName("DataLogInfo")
    @Expose
    private String DataLogInfo;

    /**
    * Third-party Task Execution Log
Note: This field may return null, indicating that no valid value can be obtained.
    */
    @SerializedName("ThirdTaskRunLogInfo")
    @Expose
    private String ThirdTaskRunLogInfo;

    /**
    * Third-party Task Log Link Description
Note: This field may return null, indicating that no valid value can be obtained.
    */
    @SerializedName("ThirdTaskLogUrlDesc")
    @Expose
    private String ThirdTaskLogUrlDesc;

    /**
    * Number of Log Lines
Note: This field may return null, indicating that no valid value can be obtained.
    */
    @SerializedName("LineCount")
    @Expose
    private Long LineCount;

    /**
     * Get Instance running log
Note: This field may return null, indicating that no valid value can be obtained. 
     * @return LogInfo Instance running log
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public String getLogInfo() {
        return this.LogInfo;
    }

    /**
     * Set Instance running log
Note: This field may return null, indicating that no valid value can be obtained.
     * @param LogInfo Instance running log
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public void setLogInfo(String LogInfo) {
        this.LogInfo = LogInfo;
    }

    /**
     * Get The Yarn log address submitted by the instance run
Note: This field may return null, indicating that no valid value can be obtained. 
     * @return YarnLogInfo The Yarn log address submitted by the instance run
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public String [] getYarnLogInfo() {
        return this.YarnLogInfo;
    }

    /**
     * Set The Yarn log address submitted by the instance run
Note: This field may return null, indicating that no valid value can be obtained.
     * @param YarnLogInfo The Yarn log address submitted by the instance run
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public void setYarnLogInfo(String [] YarnLogInfo) {
        this.YarnLogInfo = YarnLogInfo;
    }

    /**
     * Get The datax log generated by the instance run
Note: This field may return null, indicating that no valid value can be obtained. 
     * @return DataLogInfo The datax log generated by the instance run
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public String getDataLogInfo() {
        return this.DataLogInfo;
    }

    /**
     * Set The datax log generated by the instance run
Note: This field may return null, indicating that no valid value can be obtained.
     * @param DataLogInfo The datax log generated by the instance run
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public void setDataLogInfo(String DataLogInfo) {
        this.DataLogInfo = DataLogInfo;
    }

    /**
     * Get Third-party Task Execution Log
Note: This field may return null, indicating that no valid value can be obtained. 
     * @return ThirdTaskRunLogInfo Third-party Task Execution Log
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public String getThirdTaskRunLogInfo() {
        return this.ThirdTaskRunLogInfo;
    }

    /**
     * Set Third-party Task Execution Log
Note: This field may return null, indicating that no valid value can be obtained.
     * @param ThirdTaskRunLogInfo Third-party Task Execution Log
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public void setThirdTaskRunLogInfo(String ThirdTaskRunLogInfo) {
        this.ThirdTaskRunLogInfo = ThirdTaskRunLogInfo;
    }

    /**
     * Get Third-party Task Log Link Description
Note: This field may return null, indicating that no valid value can be obtained. 
     * @return ThirdTaskLogUrlDesc Third-party Task Log Link Description
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public String getThirdTaskLogUrlDesc() {
        return this.ThirdTaskLogUrlDesc;
    }

    /**
     * Set Third-party Task Log Link Description
Note: This field may return null, indicating that no valid value can be obtained.
     * @param ThirdTaskLogUrlDesc Third-party Task Log Link Description
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public void setThirdTaskLogUrlDesc(String ThirdTaskLogUrlDesc) {
        this.ThirdTaskLogUrlDesc = ThirdTaskLogUrlDesc;
    }

    /**
     * Get Number of Log Lines
Note: This field may return null, indicating that no valid value can be obtained. 
     * @return LineCount Number of Log Lines
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public Long getLineCount() {
        return this.LineCount;
    }

    /**
     * Set Number of Log Lines
Note: This field may return null, indicating that no valid value can be obtained.
     * @param LineCount Number of Log Lines
Note: This field may return null, indicating that no valid value can be obtained.
     */
    public void setLineCount(Long LineCount) {
        this.LineCount = LineCount;
    }

    public InstanceLogInfoOpsDto() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public InstanceLogInfoOpsDto(InstanceLogInfoOpsDto source) {
        if (source.LogInfo != null) {
            this.LogInfo = new String(source.LogInfo);
        }
        if (source.YarnLogInfo != null) {
            this.YarnLogInfo = new String[source.YarnLogInfo.length];
            for (int i = 0; i < source.YarnLogInfo.length; i++) {
                this.YarnLogInfo[i] = new String(source.YarnLogInfo[i]);
            }
        }
        if (source.DataLogInfo != null) {
            this.DataLogInfo = new String(source.DataLogInfo);
        }
        if (source.ThirdTaskRunLogInfo != null) {
            this.ThirdTaskRunLogInfo = new String(source.ThirdTaskRunLogInfo);
        }
        if (source.ThirdTaskLogUrlDesc != null) {
            this.ThirdTaskLogUrlDesc = new String(source.ThirdTaskLogUrlDesc);
        }
        if (source.LineCount != null) {
            this.LineCount = new Long(source.LineCount);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "LogInfo", this.LogInfo);
        this.setParamArraySimple(map, prefix + "YarnLogInfo.", this.YarnLogInfo);
        this.setParamSimple(map, prefix + "DataLogInfo", this.DataLogInfo);
        this.setParamSimple(map, prefix + "ThirdTaskRunLogInfo", this.ThirdTaskRunLogInfo);
        this.setParamSimple(map, prefix + "ThirdTaskLogUrlDesc", this.ThirdTaskLogUrlDesc);
        this.setParamSimple(map, prefix + "LineCount", this.LineCount);

    }
}

