/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.wedata.v20210820.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ModifyTaskLinksDsResponse extends AbstractModel {

    /**
    * Succeeded or Failed

Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("Data")
    @Expose
    private Boolean Data;

    /**
    * linkID
Note: This field may return null, indicating that no valid values can be obtained.
    */
    @SerializedName("LinkId")
    @Expose
    private String LinkId;

    /**
    * The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Succeeded or Failed

Note: This field may return null, indicating that no valid values can be obtained. 
     * @return Data Succeeded or Failed

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public Boolean getData() {
        return this.Data;
    }

    /**
     * Set Succeeded or Failed

Note: This field may return null, indicating that no valid values can be obtained.
     * @param Data Succeeded or Failed

Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setData(Boolean Data) {
        this.Data = Data;
    }

    /**
     * Get linkID
Note: This field may return null, indicating that no valid values can be obtained. 
     * @return LinkId linkID
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public String getLinkId() {
        return this.LinkId;
    }

    /**
     * Set linkID
Note: This field may return null, indicating that no valid values can be obtained.
     * @param LinkId linkID
Note: This field may return null, indicating that no valid values can be obtained.
     */
    public void setLinkId(String LinkId) {
        this.LinkId = LinkId;
    }

    /**
     * Get The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     * @param RequestId The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public ModifyTaskLinksDsResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ModifyTaskLinksDsResponse(ModifyTaskLinksDsResponse source) {
        if (source.Data != null) {
            this.Data = new Boolean(source.Data);
        }
        if (source.LinkId != null) {
            this.LinkId = new String(source.LinkId);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Data", this.Data);
        this.setParamSimple(map, prefix + "LinkId", this.LinkId);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

