/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.wedata.v20250806.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class CreateDataBackfillPlanRequest extends AbstractModel {

    /**
    * Project ID
    */
    @SerializedName("ProjectId")
    @Expose
    private String ProjectId;

    /**
    * Backfill task collection.
    */
    @SerializedName("TaskIds")
    @Expose
    private String [] TaskIds;

    /**
    * Specifies the data time configuration for the backfill task.
    */
    @SerializedName("DataBackfillRangeList")
    @Expose
    private DataBackfillRange [] DataBackfillRangeList;

    /**
    * Time zone, default UTC+8.
    */
    @SerializedName("TimeZone")
    @Expose
    private String TimeZone;

    /**
    * Backfill plan name. if left empty, a string of characters is randomly generated by system.
    */
    @SerializedName("DataBackfillPlanName")
    @Expose
    private String DataBackfillPlanName;

    /**
    * Check parent task type. valid values: NONE (do not check ALL), ALL (check ALL upstream parent tasks), MAKE_SCOPE (only check in the currently selected tasks of the backfill plan). default: NONE (do not check).
    */
    @SerializedName("CheckParentType")
    @Expose
    private String CheckParentType;

    /**
    * Specifies whether to ignore event dependency for backfill. default true.
    */
    @SerializedName("SkipEventListening")
    @Expose
    private Boolean SkipEventListening;

    /**
    * Custom workflow self-dependency. valid values: yes or no. if not configured, use the original workflow self-dependency.
    */
    @SerializedName("RedefineSelfWorkflowDependency")
    @Expose
    private String RedefineSelfWorkflowDependency;

    /**
    * Customizes the degree of concurrency for instance running. if without configuring, use the existing self-dependent of the task.
    */
    @SerializedName("RedefineParallelNum")
    @Expose
    private Long RedefineParallelNum;

    /**
    * Scheduling resource group id. if left empty, indicates usage of the original task scheduling execution resource group.
    */
    @SerializedName("SchedulerResourceGroupId")
    @Expose
    private String SchedulerResourceGroupId;

    /**
    * Integration task resource group id. indicates usage of the original task scheduling execution resource group if empty.
    */
    @SerializedName("IntegrationResourceGroupId")
    @Expose
    private String IntegrationResourceGroupId;

    /**
    * Custom parameter. re-specifies the task's parameters to facilitate the execution of new logic by replenished instances.
    */
    @SerializedName("RedefineParamList")
    @Expose
    private KVPair [] RedefineParamList;

    /**
    * Backfill Execution Order - The execution order for backfill instances based on their data time. Effective only when both conditions are met:

1. Must be the same cycle task.

2. Priority is given to dependency order. If no dependencies apply, execution follows the configured order.

Valid values:

-NORMAL: No specific order (default)

-ORDER: Execute in chronological order

-REVERSE: Execute in reverse chronological order
    */
    @SerializedName("DataTimeOrder")
    @Expose
    private String DataTimeOrder;

    /**
    * Backfill Instance Regeneration Cycle - If set, this will redefine the generation cycle of backfill task instances. Currently, only daily instances can be converted into instances generated on the first day of each month.

Valid value:

MONTH_CYCLE: Monthly
    */
    @SerializedName("RedefineCycleType")
    @Expose
    private String RedefineCycleType;

    /**
     * Get Project ID 
     * @return ProjectId Project ID
     */
    public String getProjectId() {
        return this.ProjectId;
    }

    /**
     * Set Project ID
     * @param ProjectId Project ID
     */
    public void setProjectId(String ProjectId) {
        this.ProjectId = ProjectId;
    }

    /**
     * Get Backfill task collection. 
     * @return TaskIds Backfill task collection.
     */
    public String [] getTaskIds() {
        return this.TaskIds;
    }

    /**
     * Set Backfill task collection.
     * @param TaskIds Backfill task collection.
     */
    public void setTaskIds(String [] TaskIds) {
        this.TaskIds = TaskIds;
    }

    /**
     * Get Specifies the data time configuration for the backfill task. 
     * @return DataBackfillRangeList Specifies the data time configuration for the backfill task.
     */
    public DataBackfillRange [] getDataBackfillRangeList() {
        return this.DataBackfillRangeList;
    }

    /**
     * Set Specifies the data time configuration for the backfill task.
     * @param DataBackfillRangeList Specifies the data time configuration for the backfill task.
     */
    public void setDataBackfillRangeList(DataBackfillRange [] DataBackfillRangeList) {
        this.DataBackfillRangeList = DataBackfillRangeList;
    }

    /**
     * Get Time zone, default UTC+8. 
     * @return TimeZone Time zone, default UTC+8.
     */
    public String getTimeZone() {
        return this.TimeZone;
    }

    /**
     * Set Time zone, default UTC+8.
     * @param TimeZone Time zone, default UTC+8.
     */
    public void setTimeZone(String TimeZone) {
        this.TimeZone = TimeZone;
    }

    /**
     * Get Backfill plan name. if left empty, a string of characters is randomly generated by system. 
     * @return DataBackfillPlanName Backfill plan name. if left empty, a string of characters is randomly generated by system.
     */
    public String getDataBackfillPlanName() {
        return this.DataBackfillPlanName;
    }

    /**
     * Set Backfill plan name. if left empty, a string of characters is randomly generated by system.
     * @param DataBackfillPlanName Backfill plan name. if left empty, a string of characters is randomly generated by system.
     */
    public void setDataBackfillPlanName(String DataBackfillPlanName) {
        this.DataBackfillPlanName = DataBackfillPlanName;
    }

    /**
     * Get Check parent task type. valid values: NONE (do not check ALL), ALL (check ALL upstream parent tasks), MAKE_SCOPE (only check in the currently selected tasks of the backfill plan). default: NONE (do not check). 
     * @return CheckParentType Check parent task type. valid values: NONE (do not check ALL), ALL (check ALL upstream parent tasks), MAKE_SCOPE (only check in the currently selected tasks of the backfill plan). default: NONE (do not check).
     */
    public String getCheckParentType() {
        return this.CheckParentType;
    }

    /**
     * Set Check parent task type. valid values: NONE (do not check ALL), ALL (check ALL upstream parent tasks), MAKE_SCOPE (only check in the currently selected tasks of the backfill plan). default: NONE (do not check).
     * @param CheckParentType Check parent task type. valid values: NONE (do not check ALL), ALL (check ALL upstream parent tasks), MAKE_SCOPE (only check in the currently selected tasks of the backfill plan). default: NONE (do not check).
     */
    public void setCheckParentType(String CheckParentType) {
        this.CheckParentType = CheckParentType;
    }

    /**
     * Get Specifies whether to ignore event dependency for backfill. default true. 
     * @return SkipEventListening Specifies whether to ignore event dependency for backfill. default true.
     */
    public Boolean getSkipEventListening() {
        return this.SkipEventListening;
    }

    /**
     * Set Specifies whether to ignore event dependency for backfill. default true.
     * @param SkipEventListening Specifies whether to ignore event dependency for backfill. default true.
     */
    public void setSkipEventListening(Boolean SkipEventListening) {
        this.SkipEventListening = SkipEventListening;
    }

    /**
     * Get Custom workflow self-dependency. valid values: yes or no. if not configured, use the original workflow self-dependency. 
     * @return RedefineSelfWorkflowDependency Custom workflow self-dependency. valid values: yes or no. if not configured, use the original workflow self-dependency.
     */
    public String getRedefineSelfWorkflowDependency() {
        return this.RedefineSelfWorkflowDependency;
    }

    /**
     * Set Custom workflow self-dependency. valid values: yes or no. if not configured, use the original workflow self-dependency.
     * @param RedefineSelfWorkflowDependency Custom workflow self-dependency. valid values: yes or no. if not configured, use the original workflow self-dependency.
     */
    public void setRedefineSelfWorkflowDependency(String RedefineSelfWorkflowDependency) {
        this.RedefineSelfWorkflowDependency = RedefineSelfWorkflowDependency;
    }

    /**
     * Get Customizes the degree of concurrency for instance running. if without configuring, use the existing self-dependent of the task. 
     * @return RedefineParallelNum Customizes the degree of concurrency for instance running. if without configuring, use the existing self-dependent of the task.
     */
    public Long getRedefineParallelNum() {
        return this.RedefineParallelNum;
    }

    /**
     * Set Customizes the degree of concurrency for instance running. if without configuring, use the existing self-dependent of the task.
     * @param RedefineParallelNum Customizes the degree of concurrency for instance running. if without configuring, use the existing self-dependent of the task.
     */
    public void setRedefineParallelNum(Long RedefineParallelNum) {
        this.RedefineParallelNum = RedefineParallelNum;
    }

    /**
     * Get Scheduling resource group id. if left empty, indicates usage of the original task scheduling execution resource group. 
     * @return SchedulerResourceGroupId Scheduling resource group id. if left empty, indicates usage of the original task scheduling execution resource group.
     */
    public String getSchedulerResourceGroupId() {
        return this.SchedulerResourceGroupId;
    }

    /**
     * Set Scheduling resource group id. if left empty, indicates usage of the original task scheduling execution resource group.
     * @param SchedulerResourceGroupId Scheduling resource group id. if left empty, indicates usage of the original task scheduling execution resource group.
     */
    public void setSchedulerResourceGroupId(String SchedulerResourceGroupId) {
        this.SchedulerResourceGroupId = SchedulerResourceGroupId;
    }

    /**
     * Get Integration task resource group id. indicates usage of the original task scheduling execution resource group if empty. 
     * @return IntegrationResourceGroupId Integration task resource group id. indicates usage of the original task scheduling execution resource group if empty.
     */
    public String getIntegrationResourceGroupId() {
        return this.IntegrationResourceGroupId;
    }

    /**
     * Set Integration task resource group id. indicates usage of the original task scheduling execution resource group if empty.
     * @param IntegrationResourceGroupId Integration task resource group id. indicates usage of the original task scheduling execution resource group if empty.
     */
    public void setIntegrationResourceGroupId(String IntegrationResourceGroupId) {
        this.IntegrationResourceGroupId = IntegrationResourceGroupId;
    }

    /**
     * Get Custom parameter. re-specifies the task's parameters to facilitate the execution of new logic by replenished instances. 
     * @return RedefineParamList Custom parameter. re-specifies the task's parameters to facilitate the execution of new logic by replenished instances.
     */
    public KVPair [] getRedefineParamList() {
        return this.RedefineParamList;
    }

    /**
     * Set Custom parameter. re-specifies the task's parameters to facilitate the execution of new logic by replenished instances.
     * @param RedefineParamList Custom parameter. re-specifies the task's parameters to facilitate the execution of new logic by replenished instances.
     */
    public void setRedefineParamList(KVPair [] RedefineParamList) {
        this.RedefineParamList = RedefineParamList;
    }

    /**
     * Get Backfill Execution Order - The execution order for backfill instances based on their data time. Effective only when both conditions are met:

1. Must be the same cycle task.

2. Priority is given to dependency order. If no dependencies apply, execution follows the configured order.

Valid values:

-NORMAL: No specific order (default)

-ORDER: Execute in chronological order

-REVERSE: Execute in reverse chronological order 
     * @return DataTimeOrder Backfill Execution Order - The execution order for backfill instances based on their data time. Effective only when both conditions are met:

1. Must be the same cycle task.

2. Priority is given to dependency order. If no dependencies apply, execution follows the configured order.

Valid values:

-NORMAL: No specific order (default)

-ORDER: Execute in chronological order

-REVERSE: Execute in reverse chronological order
     */
    public String getDataTimeOrder() {
        return this.DataTimeOrder;
    }

    /**
     * Set Backfill Execution Order - The execution order for backfill instances based on their data time. Effective only when both conditions are met:

1. Must be the same cycle task.

2. Priority is given to dependency order. If no dependencies apply, execution follows the configured order.

Valid values:

-NORMAL: No specific order (default)

-ORDER: Execute in chronological order

-REVERSE: Execute in reverse chronological order
     * @param DataTimeOrder Backfill Execution Order - The execution order for backfill instances based on their data time. Effective only when both conditions are met:

1. Must be the same cycle task.

2. Priority is given to dependency order. If no dependencies apply, execution follows the configured order.

Valid values:

-NORMAL: No specific order (default)

-ORDER: Execute in chronological order

-REVERSE: Execute in reverse chronological order
     */
    public void setDataTimeOrder(String DataTimeOrder) {
        this.DataTimeOrder = DataTimeOrder;
    }

    /**
     * Get Backfill Instance Regeneration Cycle - If set, this will redefine the generation cycle of backfill task instances. Currently, only daily instances can be converted into instances generated on the first day of each month.

Valid value:

MONTH_CYCLE: Monthly 
     * @return RedefineCycleType Backfill Instance Regeneration Cycle - If set, this will redefine the generation cycle of backfill task instances. Currently, only daily instances can be converted into instances generated on the first day of each month.

Valid value:

MONTH_CYCLE: Monthly
     */
    public String getRedefineCycleType() {
        return this.RedefineCycleType;
    }

    /**
     * Set Backfill Instance Regeneration Cycle - If set, this will redefine the generation cycle of backfill task instances. Currently, only daily instances can be converted into instances generated on the first day of each month.

Valid value:

MONTH_CYCLE: Monthly
     * @param RedefineCycleType Backfill Instance Regeneration Cycle - If set, this will redefine the generation cycle of backfill task instances. Currently, only daily instances can be converted into instances generated on the first day of each month.

Valid value:

MONTH_CYCLE: Monthly
     */
    public void setRedefineCycleType(String RedefineCycleType) {
        this.RedefineCycleType = RedefineCycleType;
    }

    public CreateDataBackfillPlanRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public CreateDataBackfillPlanRequest(CreateDataBackfillPlanRequest source) {
        if (source.ProjectId != null) {
            this.ProjectId = new String(source.ProjectId);
        }
        if (source.TaskIds != null) {
            this.TaskIds = new String[source.TaskIds.length];
            for (int i = 0; i < source.TaskIds.length; i++) {
                this.TaskIds[i] = new String(source.TaskIds[i]);
            }
        }
        if (source.DataBackfillRangeList != null) {
            this.DataBackfillRangeList = new DataBackfillRange[source.DataBackfillRangeList.length];
            for (int i = 0; i < source.DataBackfillRangeList.length; i++) {
                this.DataBackfillRangeList[i] = new DataBackfillRange(source.DataBackfillRangeList[i]);
            }
        }
        if (source.TimeZone != null) {
            this.TimeZone = new String(source.TimeZone);
        }
        if (source.DataBackfillPlanName != null) {
            this.DataBackfillPlanName = new String(source.DataBackfillPlanName);
        }
        if (source.CheckParentType != null) {
            this.CheckParentType = new String(source.CheckParentType);
        }
        if (source.SkipEventListening != null) {
            this.SkipEventListening = new Boolean(source.SkipEventListening);
        }
        if (source.RedefineSelfWorkflowDependency != null) {
            this.RedefineSelfWorkflowDependency = new String(source.RedefineSelfWorkflowDependency);
        }
        if (source.RedefineParallelNum != null) {
            this.RedefineParallelNum = new Long(source.RedefineParallelNum);
        }
        if (source.SchedulerResourceGroupId != null) {
            this.SchedulerResourceGroupId = new String(source.SchedulerResourceGroupId);
        }
        if (source.IntegrationResourceGroupId != null) {
            this.IntegrationResourceGroupId = new String(source.IntegrationResourceGroupId);
        }
        if (source.RedefineParamList != null) {
            this.RedefineParamList = new KVPair[source.RedefineParamList.length];
            for (int i = 0; i < source.RedefineParamList.length; i++) {
                this.RedefineParamList[i] = new KVPair(source.RedefineParamList[i]);
            }
        }
        if (source.DataTimeOrder != null) {
            this.DataTimeOrder = new String(source.DataTimeOrder);
        }
        if (source.RedefineCycleType != null) {
            this.RedefineCycleType = new String(source.RedefineCycleType);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ProjectId", this.ProjectId);
        this.setParamArraySimple(map, prefix + "TaskIds.", this.TaskIds);
        this.setParamArrayObj(map, prefix + "DataBackfillRangeList.", this.DataBackfillRangeList);
        this.setParamSimple(map, prefix + "TimeZone", this.TimeZone);
        this.setParamSimple(map, prefix + "DataBackfillPlanName", this.DataBackfillPlanName);
        this.setParamSimple(map, prefix + "CheckParentType", this.CheckParentType);
        this.setParamSimple(map, prefix + "SkipEventListening", this.SkipEventListening);
        this.setParamSimple(map, prefix + "RedefineSelfWorkflowDependency", this.RedefineSelfWorkflowDependency);
        this.setParamSimple(map, prefix + "RedefineParallelNum", this.RedefineParallelNum);
        this.setParamSimple(map, prefix + "SchedulerResourceGroupId", this.SchedulerResourceGroupId);
        this.setParamSimple(map, prefix + "IntegrationResourceGroupId", this.IntegrationResourceGroupId);
        this.setParamArrayObj(map, prefix + "RedefineParamList.", this.RedefineParamList);
        this.setParamSimple(map, prefix + "DataTimeOrder", this.DataTimeOrder);
        this.setParamSimple(map, prefix + "RedefineCycleType", this.RedefineCycleType);

    }
}

