/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.wedata.v20250806.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class CreateDataReplenishmentPlan extends AbstractModel {

    /**
    * Specifies the backfill plan Id.
    */
    @SerializedName("DataBackfillPlanId")
    @Expose
    private String DataBackfillPlanId;

    /**
     * Get Specifies the backfill plan Id. 
     * @return DataBackfillPlanId Specifies the backfill plan Id.
     */
    public String getDataBackfillPlanId() {
        return this.DataBackfillPlanId;
    }

    /**
     * Set Specifies the backfill plan Id.
     * @param DataBackfillPlanId Specifies the backfill plan Id.
     */
    public void setDataBackfillPlanId(String DataBackfillPlanId) {
        this.DataBackfillPlanId = DataBackfillPlanId;
    }

    public CreateDataReplenishmentPlan() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public CreateDataReplenishmentPlan(CreateDataReplenishmentPlan source) {
        if (source.DataBackfillPlanId != null) {
            this.DataBackfillPlanId = new String(source.DataBackfillPlanId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "DataBackfillPlanId", this.DataBackfillPlanId);

    }
}

