/*
 * Copyright (c) 2017-2025 Tencent. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.yunjing.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class RecoverMalwaresResponse extends AbstractModel {

    /**
    * Array of IDs of successfully recovered trojans.
    */
    @SerializedName("SuccessIds")
    @Expose
    private Long [] SuccessIds;

    /**
    * Array of IDs of trojans failed to be recovered.
    */
    @SerializedName("FailedIds")
    @Expose
    private Long [] FailedIds;

    /**
    * The unique request ID, which is returned for each request. RequestId is required for locating a problem.
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get Array of IDs of successfully recovered trojans. 
     * @return SuccessIds Array of IDs of successfully recovered trojans.
     */
    public Long [] getSuccessIds() {
        return this.SuccessIds;
    }

    /**
     * Set Array of IDs of successfully recovered trojans.
     * @param SuccessIds Array of IDs of successfully recovered trojans.
     */
    public void setSuccessIds(Long [] SuccessIds) {
        this.SuccessIds = SuccessIds;
    }

    /**
     * Get Array of IDs of trojans failed to be recovered. 
     * @return FailedIds Array of IDs of trojans failed to be recovered.
     */
    public Long [] getFailedIds() {
        return this.FailedIds;
    }

    /**
     * Set Array of IDs of trojans failed to be recovered.
     * @param FailedIds Array of IDs of trojans failed to be recovered.
     */
    public void setFailedIds(Long [] FailedIds) {
        this.FailedIds = FailedIds;
    }

    /**
     * Get The unique request ID, which is returned for each request. RequestId is required for locating a problem. 
     * @return RequestId The unique request ID, which is returned for each request. RequestId is required for locating a problem.
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set The unique request ID, which is returned for each request. RequestId is required for locating a problem.
     * @param RequestId The unique request ID, which is returned for each request. RequestId is required for locating a problem.
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public RecoverMalwaresResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public RecoverMalwaresResponse(RecoverMalwaresResponse source) {
        if (source.SuccessIds != null) {
            this.SuccessIds = new Long[source.SuccessIds.length];
            for (int i = 0; i < source.SuccessIds.length; i++) {
                this.SuccessIds[i] = new Long(source.SuccessIds[i]);
            }
        }
        if (source.FailedIds != null) {
            this.FailedIds = new Long[source.FailedIds.length];
            for (int i = 0; i < source.FailedIds.length; i++) {
                this.FailedIds[i] = new Long(source.FailedIds[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArraySimple(map, prefix + "SuccessIds.", this.SuccessIds);
        this.setParamArraySimple(map, prefix + "FailedIds.", this.FailedIds);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

