/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.asr.service;

import com.tencent.asr.model.AsrConfig;
import com.tencent.asr.model.AsrRequest;
import com.tencent.asr.model.AsrRequestContent;
import com.tencent.asr.model.FlashRecognitionRequest;
import com.tencent.core.help.SignHelper;
import java.util.Map;
import java.util.TreeMap;

class SpeechRecognitionSignService {
    SpeechRecognitionSignService() {
    }

    public String signUrl(AsrConfig asrConfig, AsrRequest request, AsrRequestContent content) {
        String paramUrl = SignHelper.createUrl(this.getParams(asrConfig, request, content));
        return asrConfig.getSignUrl() + asrConfig.getAppId() + paramUrl;
    }

    public String signWsUrl(AsrConfig asrConfig, AsrRequest request, AsrRequestContent content) {
        String paramUrl = SignHelper.createUrl(this.getWsParams(asrConfig, request, content));
        return asrConfig.getWsSignUrl() + asrConfig.getAppId() + paramUrl;
    }

    public String signFlashUrl(String url, AsrConfig asrConfig, FlashRecognitionRequest request) {
        String paramUrl = SignHelper.createUrl(this.getFlashParams(asrConfig, request));
        return url + asrConfig.getAppId() + paramUrl;
    }

    public Map<String, Object> getFlashParams(AsrConfig asrConfig, FlashRecognitionRequest request) {
        TMap<String, Object> treeMap = this.getFlashRequestParamMap(asrConfig, request);
        if (request.getExtendsParam() != null) {
            for (Map.Entry<String, Object> entry : request.getExtendsParam().entrySet()) {
                treeMap.put((Object)entry.getKey(), entry.getValue());
            }
        }
        return treeMap;
    }

    public TreeMap<String, Object> getParams(AsrConfig asrConfig, AsrRequest request, AsrRequestContent content) {
        TMap<String, Object> treeMap = this.getRequestParamMap(asrConfig, request, content);
        treeMap.put((Object)"seq", (Object)content.getSeq());
        treeMap.put((Object)"end", (Object)content.getEnd());
        if (request.getExtendsParam() != null) {
            for (Map.Entry<String, Object> entry : request.getExtendsParam().entrySet()) {
                treeMap.put((Object)entry.getKey(), entry.getValue());
            }
        }
        return treeMap;
    }

    public TreeMap<String, Object> getWsParams(AsrConfig asrConfig, AsrRequest request, AsrRequestContent content) {
        TMap<String, Object> treeMap = this.getRequestParamMap(asrConfig, request, content);
        if (request.getExtendsParam() != null) {
            for (Map.Entry<String, Object> entry : request.getExtendsParam().entrySet()) {
                treeMap.put((Object)entry.getKey(), entry.getValue());
            }
        }
        return treeMap;
    }

    private TMap<String, Object> getRequestParamMap(AsrConfig asrConfig, AsrRequest request, AsrRequestContent content) {
        TMap<String, Object> treeMap = new TMap<String, Object>();
        treeMap.put((Object)"secretid", (Object)asrConfig.getSecretId());
        treeMap.put((Object)"projectid", (Object)request.getProjectId());
        treeMap.put((Object)"sub_service_type", (Object)request.getSubServiceType());
        treeMap.put((Object)"engine_model_type", (Object)request.getEngineModelType());
        treeMap.put((Object)"res_type", (Object)request.getResType());
        treeMap.put((Object)"result_text_format", (Object)request.getResultTextFormat());
        treeMap.put((Object)"voice_id", (Object)content.getVoiceId());
        treeMap.put((Object)"timeout", (Object)request.getTimeout());
        treeMap.put((Object)"source", (Object)request.getSource());
        treeMap.put((Object)"voice_format", (Object)request.getVoiceFormat());
        treeMap.put((Object)"timestamp", (Object)request.getTimestamp());
        treeMap.put((Object)"expired", (Object)request.getExpired());
        treeMap.put((Object)"nonce", (Object)request.getNonce());
        treeMap.put((Object)"needvad", (Object)request.getNeedVad());
        treeMap.put((Object)"hotword_id", (Object)request.getHotWordId());
        treeMap.put((Object)"filter_dirty", (Object)request.getFilterDirty());
        treeMap.put((Object)"filter_modal", (Object)request.getFilterModal());
        treeMap.put((Object)"filter_punc", (Object)request.getFilterPunc());
        treeMap.put((Object)"convert_num_mode", (Object)request.getConvertNumMode());
        treeMap.put((Object)"word_info", (Object)request.getWordInfo());
        treeMap.put((Object)"vad_silence_time", (Object)request.getVadSilenceTime());
        treeMap.put((Object)"customization_id", (Object)request.getCustomizationId());
        treeMap.put((Object)"noise_threshold", (Object)request.getNoiseThreshold());
        return treeMap;
    }

    private TMap<String, Object> getFlashRequestParamMap(AsrConfig asrConfig, FlashRecognitionRequest request) {
        TMap<String, Object> treeMap = new TMap<String, Object>();
        treeMap.put((Object)"secretid", (Object)asrConfig.getSecretId());
        treeMap.put((Object)"engine_type", (Object)request.getEngineType());
        treeMap.put((Object)"voice_format", (Object)request.getVoiceFormat());
        treeMap.put((Object)"timestamp", (Object)request.getTimestamp());
        treeMap.put((Object)"speaker_diarization", (Object)request.getSpeakerDiarization());
        treeMap.put((Object)"filter_dirty", (Object)request.getFilterDirty());
        treeMap.put((Object)"filter_modal", (Object)request.getFilterModal());
        treeMap.put((Object)"filter_punc", (Object)request.getFilterPunc());
        treeMap.put((Object)"convert_num_mode", (Object)request.getConvertNumMode());
        treeMap.put((Object)"word_info", (Object)request.getWordInfo());
        treeMap.put((Object)"first_channel_only", (Object)request.getFirstChannelOnly());
        treeMap.put((Object)"hotword_id", (Object)request.getHotWordId());
        treeMap.put((Object)"customization_id", (Object)request.getCustomizationId());
        treeMap.put((Object)"sentence_max_length", (Object)request.getSentenceMaxLength());
        return treeMap;
    }

    static class TMap<K, V>
    extends TreeMap {
        TMap() {
        }

        @Override
        public Object put(Object key, Object value) {
            if (value != null) {
                return super.put(key, value);
            }
            return null;
        }
    }
}

