/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.asr.model;

import com.tencent.core.model.GlobalConfig;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.internal.Util;
import okhttp3.logging.HttpLoggingInterceptor;

public class VirtualNumberServerConfig {
    private String signPrefixUrl = "asr.cloud.tencent.com/asr/virtual_number/v1/";
    private String host = "asr.cloud.tencent.com";
    private String hostSuffix = "/asr/virtual_number/v1/";
    private String proto = "wss";
    private OkHttpClient client;
    private int onopenWaitTime;
    private int closeWaitTime;
    private int retryRequestNum;
    private int maxIdlConnections;
    private int keepAliveDuration;
    private int writeTimeOut;
    private int readTimeOut;
    private int connectTimeOut;
    private boolean useProxy;
    private String proxyHost;
    private int proxyPort;
    private int maxRequests;
    private int maxRequestsPerHost;
    private static VirtualNumberServerConfig config;

    public String getSignPrefixUrl() {
        return this.signPrefixUrl;
    }

    public void setSignPrefixUrl(String signPrefixUrl) {
        this.signPrefixUrl = signPrefixUrl;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHostSuffix() {
        return this.hostSuffix;
    }

    public void setHostSuffix(String hostSuffix) {
        this.hostSuffix = hostSuffix;
    }

    public String getProto() {
        return this.proto;
    }

    public void setProto(String proto) {
        this.proto = proto;
    }

    public static VirtualNumberServerConfig getConfig() {
        return config;
    }

    public static void setConfig(VirtualNumberServerConfig config) {
        VirtualNumberServerConfig.config = config;
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    public void setClient(OkHttpClient client) {
        this.client = client;
    }

    public int getOnopenWaitTime() {
        return this.onopenWaitTime;
    }

    public void setOnopenWaitTime(int onopenWaitTime) {
        this.onopenWaitTime = onopenWaitTime;
    }

    public int getCloseWaitTime() {
        return this.closeWaitTime;
    }

    public void setCloseWaitTime(int closeWaitTime) {
        this.closeWaitTime = closeWaitTime;
    }

    public int getRetryRequestNum() {
        return this.retryRequestNum;
    }

    public void setRetryRequestNum(int retryRequestNum) {
        this.retryRequestNum = retryRequestNum;
    }

    public int getMaxIdlConnections() {
        return this.maxIdlConnections;
    }

    public void setMaxIdlConnections(int maxIdlConnections) {
        this.maxIdlConnections = maxIdlConnections;
    }

    public int getKeepAliveDuration() {
        return this.keepAliveDuration;
    }

    public void setKeepAliveDuration(int keepAliveDuration) {
        this.keepAliveDuration = keepAliveDuration;
    }

    public int getWriteTimeOut() {
        return this.writeTimeOut;
    }

    public void setWriteTimeOut(int writeTimeOut) {
        this.writeTimeOut = writeTimeOut;
    }

    public int getReadTimeOut() {
        return this.readTimeOut;
    }

    public void setReadTimeOut(int readTimeOut) {
        this.readTimeOut = readTimeOut;
    }

    public int getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public void setConnectTimeOut(int connectTimeOut) {
        this.connectTimeOut = connectTimeOut;
    }

    public boolean isUseProxy() {
        return this.useProxy;
    }

    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public int getMaxRequests() {
        return this.maxRequests;
    }

    public void setMaxRequests(int maxRequests) {
        this.maxRequests = maxRequests;
    }

    public int getMaxRequestsPerHost() {
        return this.maxRequestsPerHost;
    }

    public void setMaxRequestsPerHost(int maxRequestsPerHost) {
        this.maxRequestsPerHost = maxRequestsPerHost;
    }

    public OkHttpClient initOkHttp() {
        ThreadPoolExecutor treadPool = new ThreadPoolExecutor(10, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory((String)"OkHttp Dispatcher", (boolean)false));
        OkHttpClient.Builder okHttpBuilder = new OkHttpClient.Builder();
        okHttpBuilder.dispatcher(new Dispatcher((ExecutorService)treadPool)).connectionPool(new ConnectionPool(this.maxIdlConnections, (long)this.keepAliveDuration, TimeUnit.MILLISECONDS)).writeTimeout((long)this.writeTimeOut, TimeUnit.MILLISECONDS).readTimeout((long)this.readTimeOut, TimeUnit.MILLISECONDS).connectTimeout((long)this.connectTimeOut, TimeUnit.MILLISECONDS).retryOnConnectionFailure(true);
        if (GlobalConfig.ifLog) {
            HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
            loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
            okHttpBuilder.addInterceptor((Interceptor)loggingInterceptor);
        }
        if (this.useProxy) {
            okHttpBuilder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, this.proxyPort)));
        }
        this.client = okHttpBuilder.build();
        this.client.dispatcher().setMaxRequests(this.maxRequests);
        this.client.dispatcher().setMaxRequestsPerHost(this.maxRequestsPerHost);
        return this.client;
    }

    public static VirtualNumberServerConfig InitVirtualNumberServerConfig() {
        VirtualNumberServerConfig config = new VirtualNumberServerConfig();
        config.setOnopenWaitTime(2);
        config.setCloseWaitTime(1);
        config.setRetryRequestNum(3);
        config.setMaxIdlConnections(600);
        config.setKeepAliveDuration(300000);
        config.setConnectTimeOut(60000);
        config.setUseProxy(false);
        config.setMaxRequests(500);
        config.setMaxRequestsPerHost(5);
        config.setReadTimeOut(60000);
        config.setClient(config.initOkHttp());
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VirtualNumberServerConfig getInstance() {
        if (config != null) return config;
        Class<VirtualNumberServerConfig> clazz = VirtualNumberServerConfig.class;
        synchronized (VirtualNumberServerConfig.class) {
            if (config != null) return config;
            config = VirtualNumberServerConfig.InitVirtualNumberServerConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return config;
        }
    }
}

