/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.asr.service;

import com.tencent.asr.constant.AsrConstant;
import com.tencent.asr.model.AsrConfig;
import com.tencent.asr.model.AsrRequest;
import com.tencent.asr.model.AsrResponse;
import com.tencent.asr.model.SpeechRecognitionResponse;
import com.tencent.asr.service.HttpBaseService;
import com.tencent.asr.service.SpeechRecognitionListener;
import com.tencent.asr.service.SpeechRecognizer;
import com.tencent.core.handler.BaseEventListener;
import com.tencent.core.handler.RealTimeEventListener;
import com.tencent.core.service.ReportService;
import com.tencent.core.service.TCall;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

public class SpeechHttpRecognizer
extends HttpBaseService
implements TCall<byte[]>,
SpeechRecognizer {
    private AtomicBoolean startFlag = new AtomicBoolean(false);

    public SpeechHttpRecognizer(String streamId, AsrConfig config, AsrRequest request, SpeechRecognitionListener speechRecognitionListener) {
        super(streamId, config, request, speechRecognitionListener);
    }

    public SpeechHttpRecognizer(String streamId, AsrConfig config, AsrRequest request, RealTimeEventListener realTimeEventListener, BaseEventListener<AsrResponse> baseEventListener) {
        super(streamId, config, request, realTimeEventListener, baseEventListener);
    }

    @Override
    public Boolean start() {
        if (this.startFlag.get()) {
            return this.startFlag.get();
        }
        this.tractionManager.beginTraction(this.streamId);
        this.startFlag.set(true);
        this.startListerResult();
        if (this.speechRecognitionListener != null) {
            SpeechRecognitionResponse recognitionResponse = new SpeechRecognitionResponse();
            recognitionResponse.setCode(0);
            recognitionResponse.setFinalSpeech(0);
            recognitionResponse.setStreamId(this.streamId);
            recognitionResponse.setVoiceId(this.staging.getVoiceId());
            recognitionResponse.setMessage("success");
            this.speechRecognitionListener.onRecognitionStart(recognitionResponse);
        }
        return this.startFlag.get();
    }

    @Override
    public void after() {
        this.tractionManager.endTraction(this.streamId);
    }

    @Override
    public Boolean end() {
        return this.stop();
    }

    @Override
    public TCall execute(byte[] stream) throws IOException {
        this.write(stream);
        return this;
    }

    @Override
    public Boolean stop() {
        if (this.finishFlag.get()) {
            return true;
        }
        ReportService.ifLogMessage(this.staging.getStreamId(), "speech end", false);
        this.endFlag.set(true);
        boolean flag = this.asrRequest.getVoiceFormat().intValue() != AsrConstant.VoiceFormat.silk.getFormatId();
        byte[] data = flag ? new byte[2] : new byte[1];
        this.sendData(data, true);
        this.after();
        this.finishFlag.set(true);
        return this.finishFlag.get();
    }

    @Override
    public void write(byte[] data) {
        if (!this.startFlag.get()) {
            throw new RuntimeException("please first call start method ");
        }
        if (this.finishFlag.get()) {
            return;
        }
        this.sendData(data, false);
    }
}

