/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tts.model;

import com.tencent.core.model.GlobalConfig;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.internal.Util;
import okhttp3.logging.HttpLoggingInterceptor;

public class SpeechWsSynthesisServerConfig {
    private static SpeechWsSynthesisServerConfig config;
    private String signPrefixUrl = "GETtts.cloud.tencent.com/stream_ws";
    private String host = "tts.cloud.tencent.com";
    private String path = "/stream_ws";
    private String proto = "wss://";
    private String action = "TextToStreamAudioWS";
    private OkHttpClient client;
    private int onopenWaitTime = 6;
    private int retryRequestNum = 3;

    public int getOnopenWaitTime() {
        return this.onopenWaitTime;
    }

    public void setOnopenWaitTime(int onopenWaitTime) {
        this.onopenWaitTime = onopenWaitTime;
    }

    public int getRetryRequestNum() {
        return this.retryRequestNum;
    }

    public void setRetryRequestNum(int retryRequestNum) {
        this.retryRequestNum = retryRequestNum;
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    public void setClient(OkHttpClient client) {
        this.client = client;
    }

    public String getSignPrefixUrl() {
        return this.signPrefixUrl;
    }

    public void setSignPrefixUrl(String signPrefixUrl) {
        this.signPrefixUrl = signPrefixUrl;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getProto() {
        return this.proto;
    }

    public void setProto(String proto) {
        this.proto = proto;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public static SpeechWsSynthesisServerConfig initSpeechWsSynthesisServerConfig() {
        SpeechWsSynthesisServerConfig config = new SpeechWsSynthesisServerConfig();
        config.setClient(config.initOkHttp());
        return config;
    }

    public OkHttpClient initOkHttp() {
        ThreadPoolExecutor treadPool = new ThreadPoolExecutor(10, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory((String)"OkHttp Dispatcher", (boolean)false));
        OkHttpClient.Builder okHttpBuilder = new OkHttpClient.Builder();
        okHttpBuilder.dispatcher(new Dispatcher((ExecutorService)treadPool)).connectionPool(new ConnectionPool(600, 300000L, TimeUnit.MILLISECONDS)).writeTimeout(60000L, TimeUnit.MILLISECONDS).readTimeout(60000L, TimeUnit.MILLISECONDS).connectTimeout(60000L, TimeUnit.MILLISECONDS).retryOnConnectionFailure(true);
        if (GlobalConfig.ifLog) {
            HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
            loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
            okHttpBuilder.addInterceptor((Interceptor)loggingInterceptor);
        }
        this.client = okHttpBuilder.build();
        this.client.dispatcher().setMaxRequests(500);
        this.client.dispatcher().setMaxRequestsPerHost(5);
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SpeechWsSynthesisServerConfig getInstance() {
        if (config != null) return config;
        Class<SpeechWsSynthesisServerConfig> clazz = SpeechWsSynthesisServerConfig.class;
        synchronized (SpeechWsSynthesisServerConfig.class) {
            if (config != null) return config;
            config = SpeechWsSynthesisServerConfig.initSpeechWsSynthesisServerConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return config;
        }
    }
}

