/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tts.service;

import com.tencent.asr.constant.AsrConstant;
import com.tencent.asr.service.SdkRunException;
import com.tencent.core.help.SignHelper;
import com.tencent.core.service.ReportService;
import com.tencent.core.utils.JsonUtil;
import com.tencent.core.utils.SignBuilder;
import com.tencent.core.utils.Tutils;
import com.tencent.tts.model.SpeechWsSynthesisRequest;
import com.tencent.tts.model.SpeechWsSynthesisResponse;
import com.tencent.tts.model.SpeechWsSynthesisServerConfig;
import com.tencent.tts.service.SpeechSynthesisSignService;
import com.tencent.tts.service.SpeechWsSynthesisListener;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.apache.commons.lang3.StringUtils;

public class SpeechWsSynthesizer {
    private SpeechWsSynthesisServerConfig serverConfig;
    private SpeechWsSynthesisRequest request;
    private SpeechWsSynthesisListener listener;
    private WebSocket webSocket;
    private final String wsId = UUID.randomUUID().toString();
    private AtomicBoolean startWs = new AtomicBoolean(false);
    private AtomicBoolean endWs = new AtomicBoolean(false);
    private AtomicBoolean firstWs = new AtomicBoolean(false);
    private AtomicBoolean finalWs = new AtomicBoolean(false);
    private AtomicBoolean errWs = new AtomicBoolean(false);
    private final CountDownLatch onopenWait = new CountDownLatch(1);
    private final CountDownLatch closeWait = new CountDownLatch(1);

    public SpeechWsSynthesizer(SpeechWsSynthesisServerConfig serverConfig, SpeechWsSynthesisRequest request, SpeechWsSynthesisListener listener) {
        this.serverConfig = serverConfig;
        this.request = request;
        this.listener = listener;
    }

    public void start() {
        try {
            if (this.serverConfig == null || this.listener == null || this.request == null) {
                throw new SdkRunException(AsrConstant.Code.CODE_10010);
            }
            boolean start = this.startWs.compareAndSet(false, true);
            if (!start) {
                ReportService.ifLogMessage(this.wsId, "started!!", true);
                return;
            }
            ReportService.ifLogMessage(this.wsId, "synthesizer start: begin", false);
            String suffix = SignHelper.createUrl(this.genParams(this.request, this.serverConfig, false));
            String signUrl = this.serverConfig.getSignPrefixUrl().concat(suffix);
            String sign = SignBuilder.base64_hmac_sha1(signUrl, this.request.getSecretKey());
            suffix = SignHelper.createUrl(this.genParams(this.request, this.serverConfig, true));
            String paramUrl = suffix.concat("&Signature=").concat(URLEncoder.encode(sign, "UTF-8"));
            String url = this.serverConfig.getProto().concat(this.serverConfig.getHost()).concat(this.serverConfig.getPath()).concat(paramUrl);
            Headers.Builder builder = new Headers.Builder().add("Host", this.serverConfig.getHost()).add("User-Agent", AsrConstant.SDK);
            if (StringUtils.isNotEmpty((CharSequence)this.request.getToken())) {
                builder.add("X-TC-Token", this.request.getToken());
            }
            ReportService.ifLogMessage(this.wsId, "signUrl: ".concat(signUrl).concat(" sign: ").concat(sign), false);
            ReportService.ifLogMessage(this.wsId, "key: ".concat(this.request.getSecretKey()), false);
            ReportService.ifLogMessage(this.wsId, "url: ".concat(url), false);
            Headers headers = new Headers.Builder().build();
            Request request = new Request.Builder().url(url).headers(headers).build();
            WebSocketListener webSocketListener = this.createWebSocketListener();
            this.webSocket = this.serverConfig.getClient().newWebSocket(request, webSocketListener);
            boolean onopen = this.onopenWait.await(this.serverConfig.getOnopenWaitTime(), TimeUnit.SECONDS);
            if (!onopen) {
                throw new SdkRunException(AsrConstant.Code.CODE_10001);
            }
            if (this.errWs.get()) {
                this.webSocket.cancel();
                throw new SdkRunException(AsrConstant.Code.CODE_10012);
            }
        }
        catch (SdkRunException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.startWs.set(false);
            throw new SdkRunException(e.getCause(), AsrConstant.Code.CODE_10001);
        }
    }

    private WebSocketListener createWebSocketListener() {
        return new WebSocketListener(){

            public void onClosed(WebSocket webSocket, int code, String reason) {
                ReportService.ifLogMessage(SpeechWsSynthesizer.this.wsId, "ws onClosed:" + code + " reason:" + reason, false);
            }

            public void onClosing(WebSocket webSocket, int code, String reason) {
                super.onClosing(webSocket, code, reason);
                ReportService.ifLogMessage(SpeechWsSynthesizer.this.wsId, "ws onClosing:" + code + " reason:" + reason, false);
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                ReportService.ifLogMessage(SpeechWsSynthesizer.this.wsId, "now process", false);
                boolean callback = false;
                SpeechWsSynthesisResponse synthesisResponse = new SpeechWsSynthesisResponse();
                try {
                    if (SpeechWsSynthesizer.this.endWs.get()) {
                        ReportService.ifLogMessage(SpeechWsSynthesizer.this.wsId, "now end:" + SpeechWsSynthesizer.this.endWs.get(), false);
                        return;
                    }
                    String trace = Tutils.getStackTrace(t);
                    if (StringUtils.contains((CharSequence)trace, (CharSequence)"Socket closed")) {
                        ReportService.ifLogMessage(SpeechWsSynthesizer.this.wsId, "onFailure:" + trace, true);
                        return;
                    }
                    ReportService.ifLogMessage(SpeechWsSynthesizer.this.wsId, "onFailure:" + trace + " end:" + SpeechWsSynthesizer.this.endWs.get(), true);
                    synthesisResponse.setCode(-1);
                    synthesisResponse.setMessage(trace);
                    synthesisResponse.setSessionId(SpeechWsSynthesizer.this.request.getSessionId());
                    callback = true;
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    SpeechWsSynthesizer.this.errWs.set(true);
                    SpeechWsSynthesizer.this.endWs.set(true);
                    if (callback) {
                        SpeechWsSynthesizer.this.listener.onSynthesisFail(synthesisResponse);
                    }
                    SpeechWsSynthesizer.this.closeWait.countDown();
                }
            }

            public void onMessage(WebSocket webSocket, String text) {
                boolean success = false;
                boolean finalTag = false;
                ReportService.ifLogMessage(SpeechWsSynthesizer.this.wsId, "onMessage:" + text, false);
                SpeechWsSynthesisResponse response = JsonUtil.fromJson(text, SpeechWsSynthesisResponse.class);
                try {
                    if (response != null && response.getCode() == 0) {
                        success = true;
                        if (response.getFinal() != null && response.getFinal() == 1) {
                            finalTag = true;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
                finally {
                    if (!success) {
                        SpeechWsSynthesizer.this.errWs.set(true);
                        SpeechWsSynthesizer.this.endWs.set(true);
                        SpeechWsSynthesizer.this.listener.onSynthesisFail(response);
                        SpeechWsSynthesizer.this.closeWait.countDown();
                    }
                    if (SpeechWsSynthesizer.this.onopenWait.getCount() > 0L) {
                        SpeechWsSynthesizer.this.onopenWait.countDown();
                        ReportService.ifLogMessage(SpeechWsSynthesizer.this.wsId, "onopenWait_countDown", false);
                    }
                    if (success) {
                        if (finalTag) {
                            SpeechWsSynthesizer.this.endWs.set(true);
                            SpeechWsSynthesizer.this.finalWs.set(true);
                            ReportService.ifLogMessage(SpeechWsSynthesizer.this.wsId, "closeWait countDown", false);
                            SpeechWsSynthesizer.this.listener.onSynthesisEnd(response);
                            SpeechWsSynthesizer.this.closeWait.countDown();
                        } else if (!SpeechWsSynthesizer.this.firstWs.get()) {
                            SpeechWsSynthesizer.this.listener.onSynthesisStart(response);
                            SpeechWsSynthesizer.this.firstWs.set(true);
                        } else {
                            SpeechWsSynthesizer.this.listener.onTextResult(response);
                        }
                    }
                }
            }

            public void onMessage(WebSocket webSocket, ByteString bytes) {
                if (SpeechWsSynthesizer.this.listener != null) {
                    SpeechWsSynthesizer.this.listener.onAudioResult(bytes.toByteArray());
                }
            }

            public void onOpen(WebSocket webSocket, Response response) {
                ReportService.ifLogMessage(SpeechWsSynthesizer.this.wsId, "onOpen:" + JsonUtil.toJson(response), false);
                try {
                    SpeechWsSynthesisResponse synthesisResponse = new SpeechWsSynthesisResponse();
                    synthesisResponse.setFinal(0);
                    synthesisResponse.setCode(0);
                    synthesisResponse.setSessionId(SpeechWsSynthesizer.this.request.getSessionId());
                    if (response.code() != 101) {
                        ReportService.ifLogMessage(SpeechWsSynthesizer.this.wsId, "onOpen: fail", true);
                        synthesisResponse.setCode(-1);
                        synthesisResponse.setMessage("start failed");
                        SpeechWsSynthesizer.this.listener.onSynthesisFail(synthesisResponse);
                        SpeechWsSynthesizer.this.endWs.set(true);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        };
    }

    public Boolean stop() {
        return this.stop(0);
    }

    public Boolean stop(Integer waitTime) {
        try {
            if (waitTime == 0) {
                this.closeWait.await();
            } else {
                this.closeWait.await(waitTime.intValue(), TimeUnit.SECONDS);
            }
            ReportService.ifLogMessage(this.wsId, "websocket close", false);
            boolean closed = this.webSocket.close(1000, "success");
            if (!closed) {
                ReportService.ifLogMessage(this.wsId, "websocket closed", false);
            }
        }
        catch (InterruptedException e) {
            ReportService.ifLogMessage(this.wsId, "stop_exception:" + e.getMessage(), false);
            throw new SdkRunException(e.getCause(), AsrConstant.Code.CODE_10004);
        }
        return true;
    }

    private Map<String, Object> genParams(SpeechWsSynthesisRequest request, SpeechWsSynthesisServerConfig serverConfig, boolean escape) {
        SpeechSynthesisSignService.TMap<String, Object> treeMap = new SpeechSynthesisSignService.TMap<String, Object>();
        treeMap.put((Object)"Action", (Object)serverConfig.getAction());
        treeMap.put((Object)"AppId", (Object)request.getAppId());
        treeMap.put((Object)"SecretId", (Object)request.getSecretId());
        treeMap.put((Object)"ModelType", (Object)request.getModelType());
        treeMap.put((Object)"VoiceType", (Object)request.getVoiceType());
        treeMap.put((Object)"Codec", (Object)request.getCodec());
        treeMap.put((Object)"SampleRate", (Object)request.getSampleRate());
        if (request.getSpeed() != null && (float)request.getSpeed().intValue() == request.getSpeed().floatValue()) {
            treeMap.put((Object)"Speed", (Object)request.getSpeed().intValue());
        } else {
            treeMap.put((Object)"Speed", (Object)request.getSpeed());
        }
        if (request.getVolume() != null && (float)request.getVolume().intValue() == request.getVolume().floatValue()) {
            treeMap.put((Object)"Volume", (Object)request.getVolume().intValue());
        } else {
            treeMap.put((Object)"Volume", (Object)request.getVolume());
        }
        if (escape) {
            try {
                treeMap.put((Object)"Text", (Object)URLEncoder.encode(request.getText(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        } else {
            treeMap.put((Object)"Text", (Object)request.getText());
        }
        treeMap.put((Object)"EnableSubtitle", (Object)request.getEnableSubtitle());
        treeMap.put((Object)"SegmentRate", (Object)request.getSegmentRate());
        treeMap.put((Object)"EmotionCategory", (Object)request.getEmotionCategory());
        treeMap.put((Object)"EmotionIntensity", (Object)request.getEmotionIntensity());
        treeMap.put((Object)"SessionId", (Object)request.getSessionId());
        treeMap.put((Object)"Timestamp", (Object)(System.currentTimeMillis() / 1000L));
        treeMap.put((Object)"Expired", (Object)(System.currentTimeMillis() / 1000L + 86400L));
        if (request.getExtendsParam() != null) {
            for (Map.Entry<String, Object> entry : request.getExtendsParam().entrySet()) {
                treeMap.put((Object)entry.getKey(), entry.getValue());
            }
        }
        return treeMap;
    }
}

