/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tts.model;

import com.tencent.core.model.TConfig;
import java.util.Optional;

public class SpeechSynthesisConfig
extends TConfig {
    private String action;
    private String ttsUrl;
    private String signUrl;
    private String logUrl;

    public SpeechSynthesisConfig(Long appId, String secretKey, String secretId, String ttsUrl, String signUrl, String logUrl, String token) {
        super(secretId, secretKey, appId, token);
        this.ttsUrl = Optional.ofNullable(ttsUrl).orElse("https://tts.cloud.tencent.com/stream");
        this.signUrl = Optional.ofNullable(signUrl).orElse("POSTtts.cloud.tencent.com/stream");
        this.logUrl = Optional.ofNullable(logUrl).orElse("https://asr.tencentcloudapi.com/");
        this.action = "TextToStreamAudio";
    }

    public static SpeechSynthesisConfigBuilder builder() {
        return new SpeechSynthesisConfigBuilder();
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setTtsUrl(String ttsUrl) {
        this.ttsUrl = ttsUrl;
    }

    public void setSignUrl(String signUrl) {
        this.signUrl = signUrl;
    }

    public void setLogUrl(String logUrl) {
        this.logUrl = logUrl;
    }

    public String getAction() {
        return this.action;
    }

    public String getTtsUrl() {
        return this.ttsUrl;
    }

    public String getSignUrl() {
        return this.signUrl;
    }

    public String getLogUrl() {
        return this.logUrl;
    }

    public static class SpeechSynthesisConfigBuilder {
        private Long appId;
        private String secretKey;
        private String secretId;
        private String ttsUrl;
        private String signUrl;
        private String logUrl;
        private String token;

        SpeechSynthesisConfigBuilder() {
        }

        public SpeechSynthesisConfigBuilder appId(Long appId) {
            this.appId = appId;
            return this;
        }

        public SpeechSynthesisConfigBuilder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public SpeechSynthesisConfigBuilder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public SpeechSynthesisConfigBuilder ttsUrl(String ttsUrl) {
            this.ttsUrl = ttsUrl;
            return this;
        }

        public SpeechSynthesisConfigBuilder signUrl(String signUrl) {
            this.signUrl = signUrl;
            return this;
        }

        public SpeechSynthesisConfigBuilder logUrl(String logUrl) {
            this.logUrl = logUrl;
            return this;
        }

        public SpeechSynthesisConfigBuilder token(String token) {
            this.token = token;
            return this;
        }

        public SpeechSynthesisConfig build() {
            return new SpeechSynthesisConfig(this.appId, this.secretKey, this.secretId, this.ttsUrl, this.signUrl, this.logUrl, this.token);
        }

        public String toString() {
            return "SpeechSynthesisConfig.SpeechSynthesisConfigBuilder(appId=" + this.appId + ", secretKey=" + this.secretKey + ", secretId=" + this.secretId + ", ttsUrl=" + this.ttsUrl + ", signUrl=" + this.signUrl + ", logUrl=" + this.logUrl + ", token=" + this.token + ")";
        }
    }
}

