/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.asrv2;

import com.google.gson.Gson;
import com.tencent.asrv2.SpeechRecognizer;
import com.tencent.asrv2.SpeechRecognizerResponse;
import com.tencent.core.ws.ConnectionListener;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SpeechRecognizerListener
implements ConnectionListener {
    Logger logger = LoggerFactory.getLogger(SpeechRecognizerListener.class);
    protected SpeechRecognizer recognizer;
    private String status = "init";

    public void setSpeechRecognizer(SpeechRecognizer recognizer) {
        this.recognizer = recognizer;
    }

    public abstract void onRecognitionResultChange(SpeechRecognizerResponse var1);

    public abstract void onRecognitionStart(SpeechRecognizerResponse var1);

    public abstract void onSentenceBegin(SpeechRecognizerResponse var1);

    public abstract void onSentenceEnd(SpeechRecognizerResponse var1);

    public abstract void onRecognitionComplete(SpeechRecognizerResponse var1);

    public abstract void onFail(SpeechRecognizerResponse var1);

    public abstract void onMessage(SpeechRecognizerResponse var1);

    @Override
    public void onOpen() {
        this.logger.debug("onOpen is ok");
    }

    @Override
    public void onClose(int closeCode, String reason) {
        if (this.recognizer != null) {
            this.recognizer.markClosed();
        }
        this.logger.debug("connection is closed due to {},code:{}", (Object)reason, (Object)closeCode);
    }

    @Override
    public void onMessage(String message) {
        if (message == null || message.trim().length() == 0) {
            return;
        }
        this.logger.debug("on message:{}", (Object)message);
        Gson gson = new Gson();
        SpeechRecognizerResponse response = (SpeechRecognizerResponse)gson.fromJson(message, SpeechRecognizerResponse.class);
        this.onMessage(response);
        if (this.isRecReady(response)) {
            this.onRecognitionStart(response);
            this.recognizer.markReady();
        } else if (this.isRecResult(response) && response.getResult() != null) {
            if (response.getResult().getSliceType() == 0) {
                this.onSentenceBegin(response);
            } else if (response.getResult().getSliceType() == 2) {
                this.onSentenceEnd(response);
            } else {
                this.onRecognitionResultChange(response);
            }
        } else if (this.isRecComplete(response)) {
            this.onRecognitionComplete(response);
            this.recognizer.markComplete();
        } else if (this.isTaskFailed(response)) {
            this.onFail(response);
            this.recognizer.markFail();
        } else {
            this.logger.error(message);
        }
    }

    @Override
    public void onMessage(ByteBuffer message) {
    }

    private boolean isRecReady(SpeechRecognizerResponse response) {
        if (response.getCode() == 0 && Objects.equals(this.status, "init") && response.getEnd() != 1) {
            this.status = "rec";
            return true;
        }
        return false;
    }

    private boolean isRecResult(SpeechRecognizerResponse response) {
        return response.getCode() == 0 && Objects.equals(this.status, "rec") && response.getEnd() != 1;
    }

    private boolean isRecComplete(SpeechRecognizerResponse response) {
        if (response.getCode() == 0 && response.getEnd() == 1) {
            this.status = "complete";
            return true;
        }
        return false;
    }

    private boolean isTaskFailed(SpeechRecognizerResponse response) {
        int code = response.getCode();
        if (code != 0) {
            this.status = "failed";
            return true;
        }
        return false;
    }
}

