/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.core.ws;

import com.tencent.core.ws.Connection;
import com.tencent.core.ws.ConnectionListener;
import com.tencent.core.ws.ConnectionProfile;
import com.tencent.core.ws.WebSocketClient;
import com.tencent.core.ws.WebsocketProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeechClient {
    static Logger logger = LoggerFactory.getLogger(SpeechClient.class);
    WebSocketClient client;
    public static int connectMaxTryTimes = 3;
    public static int connectTimeout = 5000;
    public static int maxFramePayloadLength = 0x320000;

    public SpeechClient(String url) {
        try {
            this.client = new WebSocketClient(url, WebsocketProfile.defaultWebsocketProfile());
        }
        catch (Exception e) {
            logger.error("fail to create SpeechClient", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public SpeechClient(String url, WebsocketProfile profile) {
        try {
            this.client = new WebSocketClient(url, profile);
        }
        catch (Exception e) {
            logger.error("fail to create SpeechClient", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Connection connect(ConnectionProfile connectionProfile, ConnectionListener listener) throws Exception {
        for (int i = 0; i <= connectMaxTryTimes; ++i) {
            try {
                return this.client.connect(connectionProfile, listener, connectTimeout, maxFramePayloadLength);
            }
            catch (Exception e) {
                if (i == 2) {
                    logger.error("failed to connect to server after {} tries,error msg is :{}", (Object)i, (Object)e.getMessage());
                    throw e;
                }
                Thread.sleep(100L);
                logger.warn("failed to connect to server the {} time:{} ,try again ", (Object)i, (Object)e.getMessage());
                continue;
            }
        }
        return null;
    }

    public void shutdown() {
        this.client.shutdown();
    }
}

