/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.core.ws;

import com.tencent.core.ws.Connection;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketConnection
implements Connection {
    private static Logger logger = LoggerFactory.getLogger(WebsocketConnection.class);
    Channel channel;
    long connectingLatency;
    long handshakeLatency;

    public WebsocketConnection(Channel channel) {
        this.channel = channel;
    }

    public WebsocketConnection(Channel channel, long connectingLatency, long handshakeLatency) {
        this.channel = channel;
        this.connectingLatency = connectingLatency;
        this.handshakeLatency = handshakeLatency;
    }

    @Override
    public String getChannelId() {
        if (this.channel != null) {
            return this.channel.id().toString();
        }
        return null;
    }

    @Override
    public boolean isActive() {
        return this.channel != null && this.channel.isActive();
    }

    @Override
    public long getConnectingLatency() {
        return this.connectingLatency;
    }

    @Override
    public long getHandshakeLatency() {
        return this.handshakeLatency;
    }

    @Override
    public void close() {
        this.channel.close();
    }

    @Override
    public void sendText(String text) {
        if (this.channel != null && this.channel.isActive()) {
            logger.debug("thread:{},send:{}", (Object)Thread.currentThread().getId(), (Object)text);
            this.channel.writeAndFlush((Object)new TextWebSocketFrame(text));
        }
    }

    @Override
    public void sendBinary(byte[] data) {
        if (this.channel != null && this.channel.isActive()) {
            this.channel.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[])data)));
        }
    }

    @Override
    public void sendPing() {
        PingWebSocketFrame frame = new PingWebSocketFrame();
        if (this.channel != null && this.channel.isActive()) {
            this.channel.writeAndFlush((Object)frame);
        }
    }
}

