/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.soe;

import com.google.gson.Gson;
import com.tencent.core.ws.ConnectionListener;
import com.tencent.soe.OralEvaluationResponse;
import com.tencent.soe.OralEvaluator;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OralEvaluationListener
implements ConnectionListener {
    Logger logger = LoggerFactory.getLogger(OralEvaluationListener.class);
    protected OralEvaluator oralEvaluator;
    private String status = "init";

    public void setOralEvaluation(OralEvaluator oralEvaluator) {
        this.oralEvaluator = oralEvaluator;
    }

    public abstract void OnIntermediateResults(OralEvaluationResponse var1);

    public abstract void onRecognitionStart(OralEvaluationResponse var1);

    public abstract void onRecognitionComplete(OralEvaluationResponse var1);

    public abstract void onFail(OralEvaluationResponse var1);

    public abstract void onMessage(OralEvaluationResponse var1);

    @Override
    public void onOpen() {
        this.logger.debug("onOpen is ok");
    }

    @Override
    public void onClose(int closeCode, String reason) {
        if (this.oralEvaluator != null) {
            this.oralEvaluator.markClosed();
        }
        this.logger.debug("connection is closed due to {},code:{}", (Object)reason, (Object)closeCode);
    }

    @Override
    public void onMessage(String message) {
        if (message == null || message.trim().length() == 0) {
            return;
        }
        this.logger.debug("on message:{}", (Object)message);
        Gson gson = new Gson();
        OralEvaluationResponse response = (OralEvaluationResponse)gson.fromJson(message, OralEvaluationResponse.class);
        this.onMessage(response);
        if (this.isRecReady(response)) {
            this.onRecognitionStart(response);
            this.oralEvaluator.markReady();
        } else if (this.isRecResult(response) && response.getResult() != null) {
            this.OnIntermediateResults(response);
        } else if (this.isRecComplete(response)) {
            this.onRecognitionComplete(response);
            this.oralEvaluator.markComplete();
        } else if (this.isTaskFailed(response)) {
            this.onFail(response);
            this.oralEvaluator.markFail();
        } else {
            this.logger.error(message);
        }
    }

    @Override
    public void onMessage(ByteBuffer message) {
    }

    private boolean isRecReady(OralEvaluationResponse response) {
        if (response.getCode() == 0 && Objects.equals(this.status, "init") && response.getEnd() != 1) {
            this.status = "rec";
            return true;
        }
        return false;
    }

    private boolean isRecResult(OralEvaluationResponse response) {
        return response.getCode() == 0 && Objects.equals(this.status, "rec") && response.getEnd() != 1;
    }

    private boolean isRecComplete(OralEvaluationResponse response) {
        if (response.getCode() == 0 && response.getEnd() == 1) {
            this.status = "complete";
            return true;
        }
        return false;
    }

    private boolean isTaskFailed(OralEvaluationResponse response) {
        int code = response.getCode();
        if (code != 0) {
            this.status = "failed";
            return true;
        }
        return false;
    }
}

