/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.vc;

import com.google.gson.Gson;
import com.tencent.core.ws.ConnectionListener;
import com.tencent.vc.VoiceConversionResponse;
import com.tencent.vc.VoiceConversionUtils;
import com.tencent.vc.VoiceConverter;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VoiceConversionListener
implements ConnectionListener {
    Logger logger = LoggerFactory.getLogger(VoiceConversionListener.class);
    protected VoiceConverter voiceConverter;
    private String status = "init";

    public void setVoiceConverter(VoiceConverter voiceConverter) {
        this.voiceConverter = voiceConverter;
    }

    public abstract void OnVoiceConversionStart(VoiceConversionResponse var1);

    public abstract void OnVoiceConversionResultChange(VoiceConversionResponse var1);

    public abstract void OnVoiceConversionComplete(VoiceConversionResponse var1);

    public abstract void OnFail(VoiceConversionResponse var1);

    @Override
    public void onOpen() {
        this.logger.debug("onOpen is ok");
    }

    @Override
    public void onClose(int closeCode, String reason) {
        if (this.voiceConverter != null) {
            this.voiceConverter.markClosed();
        }
        this.logger.debug("connection is closed due to {},code:{}", (Object)reason, (Object)closeCode);
    }

    @Override
    public void onMessage(String message) {
    }

    @Override
    public void onMessage(ByteBuffer message) {
        if (message == null) {
            return;
        }
        this.logger.debug("on message:{}", (Object)message);
        byte[] result = new byte[message.remaining()];
        message.get(result);
        VoiceConversionResponse response = VoiceConversionUtils.parseResponse(result);
        if (response == null) {
            this.logger.error("onMessage response null");
            return;
        }
        if (this.isRecReady(response)) {
            this.OnVoiceConversionStart(response);
            this.voiceConverter.markReady();
        } else if (this.isRecResult(response)) {
            this.OnVoiceConversionResultChange(response);
        } else if (this.isRecComplete(response)) {
            this.OnVoiceConversionComplete(response);
            this.voiceConverter.markComplete();
        } else if (this.isTaskFailed(response)) {
            this.OnFail(response);
            this.voiceConverter.markFail();
        } else {
            this.logger.error(new Gson().toJson((Object)response));
        }
    }

    private boolean isRecReady(VoiceConversionResponse response) {
        if (response.getCode() == 0 && Objects.equals(this.status, "init") && response.getEnd() != 1) {
            this.status = "rec";
            return true;
        }
        return false;
    }

    private boolean isRecResult(VoiceConversionResponse response) {
        return response.getCode() == 0 && Objects.equals(this.status, "rec") && response.getEnd() != 1;
    }

    private boolean isRecComplete(VoiceConversionResponse response) {
        if (response.getCode() == 0 && response.getEnd() == 1) {
            this.status = "complete";
            return true;
        }
        return false;
    }

    private boolean isTaskFailed(VoiceConversionResponse response) {
        int code = response.getCode();
        if (code != 0) {
            this.status = "failed";
            return true;
        }
        return false;
    }
}

