/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.asr.service;

import cn.hutool.core.map.MapUtil;
import com.tencent.asr.constant.AsrConstant;
import com.tencent.asr.model.VirtualNumberRequest;
import com.tencent.asr.model.VirtualNumberResponse;
import com.tencent.asr.model.VirtualNumberServerConfig;
import com.tencent.asr.service.SdkRunException;
import com.tencent.asr.service.SpeechRecognitionSignService;
import com.tencent.asr.service.VirtualNumberRecognitionListener;
import com.tencent.core.help.SignHelper;
import com.tencent.core.service.ReportService;
import com.tencent.core.utils.JsonUtil;
import com.tencent.core.utils.SignBuilder;
import com.tencent.core.utils.Tutils;
import java.net.URLEncoder;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.apache.commons.lang3.StringUtils;

public class VirtualNumberRecognizer {
    private VirtualNumberServerConfig serverConfig;
    private VirtualNumberRequest request;
    private VirtualNumberRecognitionListener listener;
    private WebSocket webSocket;
    private final String wsId = UUID.randomUUID().toString();
    private AtomicBoolean startWs = new AtomicBoolean(false);
    private AtomicBoolean endWs = new AtomicBoolean(false);
    private AtomicBoolean finalWs = new AtomicBoolean(false);
    private AtomicBoolean errWs = new AtomicBoolean(false);
    private final CountDownLatch onopenWait = new CountDownLatch(1);
    private final CountDownLatch closeWait = new CountDownLatch(1);

    public VirtualNumberRecognizer(VirtualNumberServerConfig serverConfig, VirtualNumberRequest request, VirtualNumberRecognitionListener listener) {
        this.serverConfig = serverConfig;
        this.request = request;
        this.listener = listener;
    }

    public boolean start() {
        try {
            if (this.serverConfig == null || this.listener == null || this.request == null) {
                throw new SdkRunException(AsrConstant.Code.CODE_10010);
            }
            boolean start = this.startWs.compareAndSet(false, true);
            if (!start) {
                ReportService.ifLogMessage(this.wsId, "started!!", true);
                return false;
            }
            String suffix = SignHelper.createUrl(this.getVirtualNumberRequestParam());
            String signUrl = this.serverConfig.getSignPrefixUrl().concat(this.request.getAppId().toString()).concat(suffix);
            String sign = SignBuilder.base64_hmac_sha1(signUrl, this.request.getSecretKey());
            String paramUrl = suffix.concat("&signature=").concat(URLEncoder.encode(sign, "UTF-8"));
            String url = this.serverConfig.getProto().concat("://").concat(this.serverConfig.getHost()).concat(this.serverConfig.getHostSuffix()).concat(this.request.getAppId().toString()).concat(paramUrl);
            WebSocketListener webSocketListener = this.createWebSocketListener();
            Headers.Builder builder = new Headers.Builder().add("Host", this.serverConfig.getHost()).add("User-Agent", AsrConstant.SDK);
            if (StringUtils.isNotEmpty((CharSequence)this.request.getToken())) {
                builder.add("X-TC-Token", this.request.getToken());
            }
            ReportService.ifLogMessage(this.wsId, "signUrl: ".concat(signUrl).concat(" sign: ").concat(sign), false);
            ReportService.ifLogMessage(this.wsId, "key: ".concat(this.request.getSecretKey()), false);
            ReportService.ifLogMessage(this.wsId, "url: ".concat(url), false);
            Headers headers = new Headers.Builder().build();
            Request request = new Request.Builder().url(url).headers(headers).build();
            this.webSocket = this.serverConfig.getClient().newWebSocket(request, webSocketListener);
            boolean onopen = this.onopenWait.await(this.serverConfig.getOnopenWaitTime(), TimeUnit.SECONDS);
            if (!onopen) {
                this.webSocket.cancel();
                ReportService.ifLogMessage(this.wsId, AsrConstant.Code.CODE_10001.getMessage(), true);
                return false;
            }
            if (this.errWs.get()) {
                this.webSocket.cancel();
                ReportService.ifLogMessage(this.wsId, AsrConstant.Code.CODE_10012.getMessage(), true);
                return false;
            }
        }
        catch (SdkRunException e) {
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.startWs.set(false);
            ReportService.ifLogMessage(this.wsId, AsrConstant.Code.CODE_10001.getMessage(), true);
            return false;
        }
        return true;
    }

    private WebSocketListener createWebSocketListener() {
        return new WebSocketListener(){

            public void onClosed(WebSocket webSocket, int code, String reason) {
                ReportService.ifLogMessage(VirtualNumberRecognizer.this.wsId, "ws onClosed:" + code + " reason:" + reason, false);
            }

            public void onClosing(WebSocket webSocket, int code, String reason) {
                super.onClosing(webSocket, code, reason);
                ReportService.ifLogMessage(VirtualNumberRecognizer.this.wsId, "ws onClosing:" + code + " reason:" + reason, false);
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                ReportService.ifLogMessage(VirtualNumberRecognizer.this.wsId, "now process", false);
                boolean callback = false;
                VirtualNumberResponse virtualNumberResponse = new VirtualNumberResponse();
                try {
                    String trace = Tutils.getStackTrace(t);
                    if (StringUtils.contains((CharSequence)trace, (CharSequence)"Socket closed")) {
                        ReportService.ifLogMessage(VirtualNumberRecognizer.this.wsId, "onFailure: socket close", true);
                        return;
                    }
                    if (VirtualNumberRecognizer.this.endWs.get()) {
                        ReportService.ifLogMessage(VirtualNumberRecognizer.this.wsId, "now end:" + VirtualNumberRecognizer.this.endWs.get(), false);
                        return;
                    }
                    ReportService.ifLogMessage(VirtualNumberRecognizer.this.wsId, "onFailure:" + trace + " end:" + VirtualNumberRecognizer.this.endWs.get(), true);
                    virtualNumberResponse.setCode(-1);
                    virtualNumberResponse.setMessage(trace);
                    virtualNumberResponse.setVoiceID(VirtualNumberRecognizer.this.request.getVoiceId());
                    callback = true;
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    VirtualNumberRecognizer.this.errWs.set(true);
                    VirtualNumberRecognizer.this.endWs.set(true);
                    if (callback) {
                        VirtualNumberRecognizer.this.listener.onFail(virtualNumberResponse);
                    }
                    VirtualNumberRecognizer.this.closeWait.countDown();
                }
            }

            public void onMessage(WebSocket webSocket, String text) {
                boolean success = false;
                boolean finalTag = false;
                ReportService.ifLogMessage(VirtualNumberRecognizer.this.wsId, "onMessage:" + text, false);
                VirtualNumberResponse response = JsonUtil.fromJson(text, VirtualNumberResponse.class);
                try {
                    if (response != null && response.getCode() == 0) {
                        success = true;
                        if (response.getFinal() != null && response.getFinal() == 1) {
                            finalTag = true;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
                finally {
                    if (!success) {
                        VirtualNumberRecognizer.this.errWs.set(true);
                        VirtualNumberRecognizer.this.endWs.set(true);
                        VirtualNumberRecognizer.this.listener.onFail(response);
                        VirtualNumberRecognizer.this.closeWait.countDown();
                    }
                    if (VirtualNumberRecognizer.this.onopenWait.getCount() > 0L) {
                        VirtualNumberRecognizer.this.onopenWait.countDown();
                        ReportService.ifLogMessage(VirtualNumberRecognizer.this.wsId, "onopenWait_countDown", false);
                    }
                    if (success) {
                        if (finalTag) {
                            VirtualNumberRecognizer.this.endWs.set(true);
                            VirtualNumberRecognizer.this.finalWs.set(true);
                            VirtualNumberRecognizer.this.closeWait.countDown();
                            ReportService.ifLogMessage(VirtualNumberRecognizer.this.wsId, "closeWait countDown", false);
                            VirtualNumberRecognizer.this.listener.onRecognitionComplete(response);
                        } else {
                            VirtualNumberRecognizer.this.listener.onRecognitionStart(response);
                        }
                    }
                }
            }

            public void onMessage(WebSocket webSocket, ByteString bytes) {
                super.onMessage(webSocket, bytes);
            }

            public void onOpen(WebSocket webSocket, Response response) {
                ReportService.ifLogMessage(VirtualNumberRecognizer.this.wsId, "onOpen:" + JsonUtil.toJson(response), false);
                try {
                    VirtualNumberResponse virtualNumberResponse = new VirtualNumberResponse();
                    virtualNumberResponse.setFinal(0);
                    virtualNumberResponse.setResult(0);
                    virtualNumberResponse.setVoiceID(VirtualNumberRecognizer.this.request.getVoiceId());
                    if (response.code() != 101) {
                        ReportService.ifLogMessage(VirtualNumberRecognizer.this.wsId, "onOpen: fail", true);
                        virtualNumberResponse.setCode(-1);
                        virtualNumberResponse.setMessage("start failed");
                        VirtualNumberRecognizer.this.listener.onFail(virtualNumberResponse);
                        VirtualNumberRecognizer.this.endWs.set(true);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        };
    }

    public Boolean stop() {
        try {
            if (!this.finalWs.get()) {
                ReportService.ifLogMessage(this.wsId, "send end package", false);
                this.webSocket.send(JsonUtil.toJson(MapUtil.builder().put((Object)"type", (Object)"end").build()));
            }
            this.closeWait.await(this.serverConfig.getCloseWaitTime(), TimeUnit.SECONDS);
            ReportService.ifLogMessage(this.wsId, "websocket close", false);
            boolean closed = this.webSocket.close(1000, "success");
            if (!closed) {
                ReportService.ifLogMessage(this.wsId, "websocket closed", false);
            }
        }
        catch (InterruptedException e) {
            ReportService.ifLogMessage(this.wsId, "stop_exception:" + e.getMessage(), false);
            return false;
        }
        return true;
    }

    public boolean write(byte[] data) {
        if (this.finalWs.get()) {
            return true;
        }
        if (this.endWs.get()) {
            ReportService.ifLogMessage(this.wsId, "has ended stop sending", true);
            throw new SdkRunException(AsrConstant.Code.CODE_10003);
        }
        ReportService.ifLogMessage(this.wsId, "send package", false);
        boolean success = this.webSocket.send(ByteString.of((byte[])data));
        ReportService.ifLogMessage(this.wsId, "send  package " + success, false);
        if (!success) {
            for (int i = 0; i < this.serverConfig.getRetryRequestNum() && !(success = this.webSocket.send(ByteString.of((byte[])data))); ++i) {
            }
        }
        return false;
    }

    private Map<String, Object> getVirtualNumberRequestParam() {
        SpeechRecognitionSignService.TMap<String, Object> queryMap = new SpeechRecognitionSignService.TMap<String, Object>();
        queryMap.put("secretid", this.request.getSecretId());
        queryMap.put("timestamp", Long.valueOf(System.currentTimeMillis() / 1000L));
        queryMap.put("expired", Long.valueOf(System.currentTimeMillis() / 1000L + 86400L));
        queryMap.put("nonce", Long.valueOf(System.currentTimeMillis()));
        queryMap.put("voice_id", this.request.getVoiceId());
        queryMap.put("voice_format", this.request.getVoiceFormat());
        queryMap.put("wait_time", this.request.getWaitTime());
        if (this.request.getExtendsParam() != null) {
            for (Map.Entry<String, Object> entry : this.request.getExtendsParam().entrySet()) {
                queryMap.put(entry.getKey(), entry.getValue());
            }
        }
        return queryMap;
    }
}

