/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.core.intercept;

import com.tencent.core.service.ReportService;
import java.io.IOException;
import java.net.SocketTimeoutException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class RetryInteceptors
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = null;
        try {
            ReportService.ifLogMessage("request URL", request.url().toString(), false);
            response = chain.proceed(request);
            if (!response.isSuccessful()) {
                response.close();
                ReportService.ifLogMessage(request.url().toString(), "Interceptor retry", true);
                response = chain.proceed(request);
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.closeResponse(response);
            ReportService.ifLogMessage(request.url().toString(), socketTimeoutException.getMessage(), true);
            response = chain.proceed(request);
        }
        return response;
    }

    private void closeResponse(Response response) {
        try {
            if (response != null) {
                if (response.body() != null) {
                    response.body().close();
                }
                response.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

