/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.core.ws;

import com.tencent.core.ws.Connection;
import com.tencent.core.ws.ConnectionListener;
import com.tencent.core.ws.ConnectionProfile;
import com.tencent.core.ws.WebSocketClientHandler;
import com.tencent.core.ws.WebsocketConnection;
import com.tencent.core.ws.WebsocketProfile;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketClient {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketClient.class);
    private WebsocketProfile websocketProfile;
    private Bootstrap bootstrap = new Bootstrap();
    private EventLoopGroup eventLoopGroup;
    private int port;
    private SslContext sslCtx;

    public WebSocketClient(String uriStr, WebsocketProfile profile) throws Exception {
        this.websocketProfile = profile;
        this.eventLoopGroup = new NioEventLoopGroup(profile.getEventGroupThreadNum());
        final URI websocketURI = new URI(uriStr);
        this.port = this.getURIPort(websocketURI);
        ((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true)).group(this.eventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline p = ch.pipeline();
                if (WebSocketClient.this.sslCtx != null) {
                    p.addLast(new ChannelHandler[]{WebSocketClient.this.sslCtx.newHandler(ch.alloc(), websocketURI.getHost(), 443)});
                }
                if (WebSocketClient.this.websocketProfile.isCompression()) {
                    p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), WebSocketClientCompressionHandler.INSTANCE});
                } else {
                    p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192)});
                }
                p.addLast("hookedHandler", (ChannelHandler)new WebSocketClientHandler());
            }
        });
    }

    public Connection connect(ConnectionProfile connectionProfile, ConnectionListener listener, int connectionTimeout, int maxFramePayloadLength) throws Exception {
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectionTimeout);
        DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
        httpHeaders.set("Authorization", (Object)connectionProfile.getSign());
        httpHeaders.set("Host", (Object)connectionProfile.getHost());
        if (connectionProfile.getToken() != null && !Objects.equals(connectionProfile.getToken(), "")) {
            httpHeaders.set("X-TC-Token", (Object)connectionProfile.getToken());
        }
        URI websocketURI = new URI(connectionProfile.getUrl());
        WebSocketClientHandshaker handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)websocketURI, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, (HttpHeaders)httpHeaders, (int)maxFramePayloadLength);
        long start = System.currentTimeMillis();
        Channel channel = this.bootstrap.connect(websocketURI.getHost(), this.port).sync().channel();
        long connectingTime = System.currentTimeMillis() - start;
        logger.debug("websocket channel is established after sync,connectionId:{} ,use {}", (Object)channel.id(), (Object)connectingTime);
        WebSocketClientHandler handler = (WebSocketClientHandler)channel.pipeline().get("hookedHandler");
        handler.setListener(listener);
        handler.setHandshaker(handshaker);
        handshaker.handshake(channel);
        start = System.currentTimeMillis();
        this.waitHandshake(handler.handshakeFuture(), channel);
        long handshakeTime = System.currentTimeMillis() - start;
        logger.debug("websocket connection is established after handshake,connectionId:{},use {}", (Object)channel.id(), (Object)handshakeTime);
        return new WebsocketConnection(channel, connectingTime, handshakeTime);
    }

    public void shutdown() {
        this.eventLoopGroup.shutdownGracefully();
    }

    private void waitHandshake(ChannelFuture handshakeFuture, Channel channel) throws Exception {
        if (handshakeFuture.await((long)this.websocketProfile.getHandshakeTimeout(), TimeUnit.SECONDS)) {
            return;
        }
        if (channel.isActive()) {
            channel.close();
        }
        if (handshakeFuture.cause() != null) {
            throw new Exception("Handshake timeout!", handshakeFuture.cause());
        }
        throw new Exception("Handshake timeout!");
    }

    private int getURIPort(URI websocketURI) throws SSLException {
        boolean ssl = "wss".equalsIgnoreCase(websocketURI.getScheme());
        int port = websocketURI.getPort();
        if (ssl) {
            this.sslCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            if (port == -1) {
                port = 443;
            }
        } else if (port == -1) {
            port = 80;
        }
        return port;
    }
}

