/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.soe;

import com.google.gson.Gson;
import com.tencent.core.help.SignHelper;
import com.tencent.core.ws.Connection;
import com.tencent.core.ws.ConnectionProfile;
import com.tencent.core.ws.Credential;
import com.tencent.core.ws.SpeechClient;
import com.tencent.core.ws.StateMachine;
import com.tencent.soe.OralEvalConstant;
import com.tencent.soe.OralEvaluationListener;
import com.tencent.soe.OralEvaluationRequest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OralEvaluator
extends StateMachine {
    static Logger logger = LoggerFactory.getLogger(OralEvaluator.class);
    private final Map<String, Object> ctx = new HashMap<String, Object>();
    private final String recUuid = UUID.randomUUID().toString();
    private final CountDownLatch stopLatch;
    private final CountDownLatch startLatch;
    protected long lastSendTime = -1L;
    protected Connection conn;
    private Credential credential;
    private OralEvaluationRequest request;
    private SpeechClient client;
    private OralEvaluationListener listener;

    public Credential getCredential() {
        return this.credential;
    }

    public void setCredential(Credential credential) {
        this.credential = credential;
    }

    public OralEvaluationRequest getRequest() {
        return this.request;
    }

    public void setRequest(OralEvaluationRequest request) {
        this.request = request;
    }

    public SpeechClient getClient() {
        return this.client;
    }

    public void setClient(SpeechClient client) {
        this.client = client;
    }

    public OralEvaluationListener getListener() {
        return this.listener;
    }

    public void setListener(OralEvaluationListener listener) {
        this.listener = listener;
    }

    public OralEvaluator(SpeechClient client, Credential credential, OralEvaluationRequest request, OralEvaluationListener listener) throws Exception {
        Optional.ofNullable(client).orElseThrow(() -> new RuntimeException("client cannot be null"));
        Optional.ofNullable(request).orElseThrow(() -> new RuntimeException("request cannot be null"));
        Optional.ofNullable(credential).orElseThrow(() -> new RuntimeException("credential cannot be null"));
        Optional.ofNullable(listener).orElseThrow(() -> new RuntimeException("listener cannot be null"));
        if (request.getVoiceId() == null) {
            request.setVoiceId(this.recUuid);
        }
        this.request = request;
        this.credential = credential;
        this.client = client;
        this.listener = listener;
        this.stopLatch = new CountDownLatch(1);
        this.startLatch = new CountDownLatch(1);
        listener.setOralEvaluation(this);
    }

    public void start() throws Exception {
        this.start(OralEvalConstant.DEFAULT_START_TIMEOUT_MILLISECONDS);
    }

    public void start(long milliSeconds) throws Exception {
        this.state.checkStart();
        logger.debug("recUuid:{},start change state from {} ", (Object)this.recUuid, (Object)this.state);
        this.state = this.state.start();
        logger.debug("recUuid:{},start change state to {} ", (Object)this.recUuid, (Object)this.state);
        this.request.setSecretid(this.credential.getSecretId());
        this.request.setTimestamp(System.currentTimeMillis() / 1000L);
        this.request.setExpired(System.currentTimeMillis() / 1000L + 86400L);
        Map<String, Object> sortParamMap = this.request.toTreeMap();
        String sign = SignHelper.createSign(OralEvalConstant.DEFAULT_ORAL_EVAL_SIGN_PREFIX, SignHelper.createUrl(sortParamMap), this.credential.getAppid(), this.credential.getSecretKey());
        Map<String, Object> encodeParam = SignHelper.encode(sortParamMap);
        String url = SignHelper.createRequestUrl(OralEvalConstant.DEFAULT_ORAL_EVAL_REQ_URL, SignHelper.createUrl(encodeParam), this.credential.getAppid());
        logger.debug(url);
        ConnectionProfile connectionProfile = new ConnectionProfile(sign, url, OralEvalConstant.DEFAULT_ORAL_EVAL_HOST, this.credential.getToken());
        this.conn = this.client.connect(connectionProfile, this.listener);
        HashMap<String, Long> network = new HashMap<String, Long>();
        network.put("connectingLatency", this.conn.getConnectingLatency());
        network.put("handshakeLatency", this.conn.getHandshakeLatency());
        this.ctx.put("network", network);
        boolean result = this.startLatch.await(milliSeconds, TimeUnit.MILLISECONDS);
        if (!result) {
            String msg = String.format("timeout after %d ms waiting for start confirmation.recUuid:%s,state:%s", new Object[]{milliSeconds, this.recUuid, this.state});
            logger.error(msg);
            throw new Exception(msg);
        }
    }

    public void write(byte[] data) {
        this.write(data, data.length);
    }

    public void write(byte[] data, int length) {
        long sendInterval;
        if (this.state == StateMachine.State.STATE_COMPLETE) {
            logger.info("state is {} stop send", (Object)StateMachine.State.STATE_COMPLETE);
            return;
        }
        if (this.lastSendTime != -1L && (sendInterval = System.currentTimeMillis() - this.lastSendTime) > 5000L) {
            logger.warn("too large binary send interval: {} million second", (Object)sendInterval);
        }
        this.state.checkSend();
        try {
            this.conn.sendBinary(Arrays.copyOfRange(data, 0, length));
            this.lastSendTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            logger.error("fail to send binary,current_task_id:{},state:{}", new Object[]{this.recUuid, this.state, e});
            throw new RuntimeException(e);
        }
    }

    public void stop() throws Exception {
        this.stop(OralEvalConstant.DEFAULT_START_TIMEOUT_MILLISECONDS);
    }

    public void stop(long milliSeconds) throws Exception {
        if (this.state == StateMachine.State.STATE_COMPLETE) {
            logger.info("state is {} stop message is discarded", (Object)StateMachine.State.STATE_COMPLETE);
            return;
        }
        this.state.checkStop();
        this.state = this.state.stopSend();
        if (this.conn != null) {
            HashMap<String, String> end = new HashMap<String, String>();
            end.put("type", "end");
            this.conn.sendText(new Gson().toJson(end));
            boolean result = this.stopLatch.await(milliSeconds, TimeUnit.MILLISECONDS);
            if (!result) {
                String msg = String.format("timeout after %d ms waiting for stop confirmation.recUuid:%s,state:%s", new Object[]{milliSeconds, this.recUuid, this.state});
                logger.error(msg);
                throw new Exception(msg);
            }
        }
    }

    public void close() {
        if (this.conn != null) {
            this.conn.close();
        }
    }

    void markReady() {
        logger.debug("recUuid:{},markReady change state from {} ", (Object)this.recUuid, (Object)this.state);
        this.state = this.state.send();
        logger.debug("recUuid:{},markReady change state to {} ", (Object)this.recUuid, (Object)this.state);
        if (this.startLatch != null) {
            this.startLatch.countDown();
        }
    }

    void markComplete() {
        logger.debug("recUuid:{},markComplete change state from {} ", (Object)this.recUuid, (Object)this.state);
        this.state = this.state.complete();
        logger.debug("recUuid:{},markComplete change state to {} ", (Object)this.recUuid, (Object)this.state);
        if (this.stopLatch != null) {
            this.stopLatch.countDown();
        }
    }

    void markFail() {
        logger.debug("recUuid:{},markFail change state from {} ", (Object)this.recUuid, (Object)this.state);
        this.state = this.state.fail();
        logger.debug("recUuid:{},markFail change state to {} ", (Object)this.recUuid, (Object)this.state);
        if (this.startLatch != null) {
            this.startLatch.countDown();
        }
        if (this.stopLatch != null) {
            this.stopLatch.countDown();
        }
    }

    void markClosed() {
        logger.debug("recUuid:{},markClosed change state from {} ", (Object)this.recUuid, (Object)this.state);
        this.state = this.state.closed();
        logger.debug("recUuid:{},markClosed change state to {} ", (Object)this.recUuid, (Object)this.state);
        if (this.startLatch != null) {
            this.startLatch.countDown();
        }
        if (this.stopLatch != null) {
            this.stopLatch.countDown();
        }
    }
}

