/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ttsv2;

import com.google.gson.Gson;
import com.tencent.core.ws.ConnectionListener;
import com.tencent.ttsv2.FlowingSpeechSynthesizer;
import com.tencent.ttsv2.SpeechSynthesizerResponse;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlowingSpeechSynthesizerListener
implements ConnectionListener {
    Logger logger = LoggerFactory.getLogger(FlowingSpeechSynthesizerListener.class);
    protected FlowingSpeechSynthesizer synthesizer;
    private String status = "init";

    public void setSpeechSynthesizer(FlowingSpeechSynthesizer synthesizer) {
        this.synthesizer = synthesizer;
    }

    public abstract void onSynthesisStart(SpeechSynthesizerResponse var1);

    public abstract void onSynthesisEnd(SpeechSynthesizerResponse var1);

    public abstract void onAudioResult(ByteBuffer var1);

    public abstract void onTextResult(SpeechSynthesizerResponse var1);

    public abstract void onSynthesisFail(SpeechSynthesizerResponse var1);

    @Override
    public void onOpen() {
        this.logger.debug("onOpen is ok");
    }

    @Override
    public void onClose(int closeCode, String reason) {
        if (this.synthesizer != null) {
            this.synthesizer.markClosed();
        }
        this.logger.debug("connection is closed due to {},code:{}", (Object)reason, (Object)closeCode);
    }

    @Override
    public void onMessage(String message) {
        if (message == null || message.trim().length() == 0) {
            return;
        }
        this.logger.debug("on message:{}", (Object)message);
        Gson gson = new Gson();
        SpeechSynthesizerResponse response = (SpeechSynthesizerResponse)gson.fromJson(message, SpeechSynthesizerResponse.class);
        if (this.isRecReady(response)) {
            this.onSynthesisStart(response);
            this.synthesizer.markReady();
        } else if (this.isRecResult(response) && response.getResult() != null) {
            this.onTextResult(response);
        } else if (this.isRecComplete(response)) {
            this.onSynthesisEnd(response);
            this.synthesizer.markComplete();
        } else if (this.isTaskFailed(response)) {
            this.onSynthesisFail(response);
            this.synthesizer.markFail();
        } else {
            this.logger.error(message);
        }
    }

    @Override
    public void onMessage(ByteBuffer message) {
        this.onAudioResult(message);
    }

    private boolean isRecReady(SpeechSynthesizerResponse response) {
        if (response.getCode() == 0 && Objects.equals(this.status, "init") && response.getEnd() != 1) {
            this.status = "rec";
            return true;
        }
        return false;
    }

    private boolean isRecResult(SpeechSynthesizerResponse response) {
        return response.getCode() == 0 && Objects.equals(this.status, "rec") && response.getEnd() != 1;
    }

    private boolean isRecComplete(SpeechSynthesizerResponse response) {
        if (response.getCode() == 0 && response.getEnd() == 1) {
            this.status = "complete";
            return true;
        }
        return false;
    }

    private boolean isTaskFailed(SpeechSynthesizerResponse response) {
        int code = response.getCode();
        if (code != 0) {
            this.status = "failed";
            return true;
        }
        return false;
    }
}

