/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.vc;

import com.google.gson.Gson;
import com.tencent.vc.VoiceConversionResponse;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;

public class VoiceConversionUtils {
    public static int byteArrayToInt(byte[] byteArray) {
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        buffer.order(ByteOrder.BIG_ENDIAN);
        return buffer.getInt();
    }

    public static byte[] wrapSendRequest(int end, byte[] audio) {
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("End", end);
        byte[] json = new Gson().toJson(param).getBytes();
        byte[] head = VoiceConversionUtils.intToByteArray(json.length);
        return VoiceConversionUtils.concatenateByteArrays(VoiceConversionUtils.concatenateByteArrays(head, json), audio);
    }

    public static byte[] intToByteArray(int number) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.putInt(number);
        return buffer.array();
    }

    public static byte[] concatenateByteArrays(byte[] array1, byte[] array2) {
        ByteBuffer buffer = ByteBuffer.allocate(array1.length + array2.length);
        buffer.put(array1);
        buffer.put(array2);
        buffer.flip();
        return buffer.array();
    }

    public static VoiceConversionResponse parseResponse(byte[] resp) {
        VoiceConversionResponse conversionResponse = null;
        try {
            if (resp.length > 4) {
                int headLen = 4;
                byte[] head = new byte[headLen];
                System.arraycopy(resp, 0, head, 0, headLen);
                int jsonLen = VoiceConversionUtils.byteArrayToInt(head);
                if (resp.length - headLen - jsonLen >= 0) {
                    byte[] json = new byte[jsonLen];
                    System.arraycopy(resp, headLen, json, 0, jsonLen);
                    conversionResponse = (VoiceConversionResponse)new Gson().fromJson(new String(json), VoiceConversionResponse.class);
                    int audioLen = resp.length - headLen - jsonLen;
                    if (conversionResponse != null && audioLen > 0) {
                        byte[] audio = new byte[audioLen];
                        System.arraycopy(resp, headLen + jsonLen, audio, 0, audioLen);
                        conversionResponse.setAudio(audio);
                    }
                }
            }
            if (conversionResponse == null) {
                conversionResponse = new VoiceConversionResponse();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return conversionResponse;
    }
}

