/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.asr.service;

import cn.hutool.core.util.RandomUtil;
import com.tencent.asr.model.AsrConfig;
import com.tencent.asr.model.FlashRecognitionRequest;
import com.tencent.asr.model.FlashRecognitionResponse;
import com.tencent.asr.model.SpeechRecognitionSysConfig;
import com.tencent.asr.service.SpeechRecognitionSignService;
import com.tencent.core.help.SignHelper;
import com.tencent.core.service.ReportService;
import com.tencent.core.utils.JsonUtil;
import com.tencent.core.utils.SignBuilder;
import com.tencent.core.utils.Tutils;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class FlashRecognizer {
    protected SpeechRecognitionSignService speechRecognitionSignService = new SpeechRecognitionSignService();
    private AsrConfig config;
    private static CloseableHttpClient client;

    public FlashRecognizer(AsrConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlashRecognitionResponse recognize(FlashRecognitionRequest request, byte[] data) {
        if (data == null || data.length == 0) {
            throw new RuntimeException("write data is null!!!");
        }
        request.setTimestamp(System.currentTimeMillis() / 1000L);
        Map<String, Object> paramMap = this.speechRecognitionSignService.getFlashParams(this.config, request);
        String paramUrl = SignHelper.createUrl(paramMap);
        String signUrl = "POST" + this.config.getFlashSignUrl() + this.config.getAppId() + paramUrl;
        String sign = SignBuilder.base64_hmac_sha1(signUrl, this.config.getSecretKey());
        if (request.getHotwordList() != null) {
            paramMap.put("hotword_list", URLEncoder.encode(request.getHotwordList()));
        }
        String url = this.config.getFlashUrl() + this.config.getAppId() + SignHelper.createUrl(paramMap);
        CloseableHttpResponse httpResponse = null;
        try {
            FlashRecognitionResponse response;
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Authorization", sign);
            httpPost.addHeader("Content-Type", "application/octet-stream");
            if (StringUtils.isNotEmpty((CharSequence)this.config.getToken())) {
                httpPost.addHeader("X-TC-Token", this.config.getToken());
            }
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(data));
            httpResponse = client.execute((HttpUriRequest)httpPost, (HttpContext)HttpClientContext.create());
            String responseStr = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"utf-8");
            FlashRecognitionResponse flashRecognitionResponse = response = JsonUtil.fromJson(responseStr, FlashRecognitionResponse.class);
            return flashRecognitionResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            FlashRecognitionResponse response = new FlashRecognitionResponse();
            response.setMessage(Tutils.getStackTraceAsString(e));
            response.setRequestId(RandomUtil.randomString((int)11));
            response.setCode(-1);
            ReportService.report(false, String.valueOf(-1), this.config, response.getRequestId(), request, response, this.config.getFlashUrl(), e.getMessage());
            FlashRecognitionResponse flashRecognitionResponse = response;
            return flashRecognitionResponse;
        }
        finally {
            try {
                if (httpResponse != null) {
                    httpResponse.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        SSLConnectionSocketFactory sslsf;
        try {
            sslsf = new SSLConnectionSocketFactory(SSLContext.getDefault(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        Registry registry = RegistryBuilder.create().register("http", (Object)new PlainConnectionSocketFactory()).register("https", (Object)sslsf).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(registry);
        cm.setMaxTotal(SpeechRecognitionSysConfig.MaxTotal);
        cm.setDefaultMaxPerRoute(SpeechRecognitionSysConfig.defaultMaxPerRoute);
        RequestConfig.Builder rb = RequestConfig.custom();
        if (SpeechRecognitionSysConfig.httpUseProxy) {
            rb.setProxy(SpeechRecognitionSysConfig.httpHostProxy);
        }
        RequestConfig requestConfig = rb.setConnectTimeout(SpeechRecognitionSysConfig.flashConnectTimeout).setSocketTimeout(SpeechRecognitionSysConfig.flashSocketTimeout).setConnectionRequestTimeout(SpeechRecognitionSysConfig.flashConnectionRequestTimeout).build();
        client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setConnectionReuseStrategy((ConnectionReuseStrategy)new NoConnectionReuseStrategy()).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(3, true)).setDefaultRequestConfig(requestConfig).build();
    }
}

