/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.benchto.driver;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.teradata.benchto.driver.Query;
import com.teradata.benchto.driver.loader.BenchmarkDescriptor;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Benchmark {
    private String name;
    private String sequenceId;
    private String dataSource;
    private String environment;
    private List<Query> queries;
    private int runs;
    private int prewarmRuns;
    private int concurrency;
    private List<String> beforeBenchmarkMacros;
    private List<String> afterBenchmarkMacros;
    private List<String> beforeExecutionMacros;
    private List<String> afterExecutionMacros;
    private Map<String, String> variables;
    private String uniqueName;
    private Optional<Duration> frequency;

    private Benchmark() {
    }

    public String getName() {
        return this.name;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public void setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    public String getSequenceId() {
        return this.sequenceId;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public List<Query> getQueries() {
        return this.queries;
    }

    public int getRuns() {
        return this.runs;
    }

    public int getPrewarmRuns() {
        return this.prewarmRuns;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public boolean isConcurrent() {
        return this.concurrency > 1;
    }

    public boolean isSerial() {
        return this.concurrency == 1;
    }

    public List<String> getBeforeBenchmarkMacros() {
        return this.beforeBenchmarkMacros;
    }

    public List<String> getAfterBenchmarkMacros() {
        return this.afterBenchmarkMacros;
    }

    public List<String> getBeforeExecutionMacros() {
        return this.beforeExecutionMacros;
    }

    public List<String> getAfterExecutionMacros() {
        return this.afterExecutionMacros;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public Map<String, String> getNonReservedKeywordVariables() {
        HashMap nonReservedKeysVariables = Maps.newHashMap(this.getVariables());
        BenchmarkDescriptor.RESERVED_KEYWORDS.stream().forEach(nonReservedKeysVariables::remove);
        return nonReservedKeysVariables;
    }

    public Optional<Duration> getFrequency() {
        return this.frequency;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("uniqueName", (Object)this.uniqueName).add("sequenceId", (Object)this.sequenceId).add("dataSource", (Object)this.dataSource).add("environment", (Object)this.environment).add("queries", this.queries).add("runs", this.runs).add("prewarmRuns", this.prewarmRuns).add("concurrency", this.concurrency).add("frequency", this.frequency).add("beforeBenchmarkMacros", this.beforeBenchmarkMacros).add("afterBenchmarkMacros", this.afterBenchmarkMacros).add("beforeExecutionMacros", this.beforeExecutionMacros).add("afterExecutionMacros", this.afterExecutionMacros).add("variables", this.variables).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Benchmark benchmark = (Benchmark)o;
        return Objects.equal((Object)this.runs, (Object)benchmark.runs) && Objects.equal((Object)this.prewarmRuns, (Object)benchmark.prewarmRuns) && Objects.equal((Object)this.concurrency, (Object)benchmark.concurrency) && Objects.equal((Object)this.name, (Object)benchmark.name) && Objects.equal((Object)this.sequenceId, (Object)benchmark.sequenceId) && Objects.equal((Object)this.dataSource, (Object)benchmark.dataSource) && Objects.equal((Object)this.environment, (Object)benchmark.environment) && Objects.equal(this.queries, benchmark.queries) && Objects.equal(this.beforeBenchmarkMacros, benchmark.beforeBenchmarkMacros) && Objects.equal(this.afterBenchmarkMacros, benchmark.afterBenchmarkMacros) && Objects.equal(this.beforeExecutionMacros, benchmark.beforeExecutionMacros) && Objects.equal(this.afterExecutionMacros, benchmark.afterExecutionMacros) && Objects.equal(this.variables, benchmark.variables) && Objects.equal(this.frequency, benchmark.frequency);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.sequenceId, this.dataSource, this.environment, this.queries, this.runs, this.prewarmRuns, this.concurrency, this.beforeBenchmarkMacros, this.afterBenchmarkMacros, this.beforeExecutionMacros, this.afterExecutionMacros, this.variables, this.frequency});
    }

    public static class BenchmarkBuilder {
        private final Benchmark benchmark = new Benchmark();

        public BenchmarkBuilder(String name, String sequenceId, List<Query> queries) {
            this.benchmark.name = name;
            this.benchmark.sequenceId = sequenceId;
            this.benchmark.queries = (List)ImmutableList.copyOf(queries);
        }

        public BenchmarkBuilder withDataSource(String dataSource) {
            this.benchmark.dataSource = dataSource;
            return this;
        }

        public BenchmarkBuilder withEnvironment(String environment) {
            this.benchmark.environment = environment;
            return this;
        }

        public BenchmarkBuilder withRuns(int runs) {
            Preconditions.checkArgument((runs >= 1 ? 1 : 0) != 0, (Object)"Runs must be greater of equal 1");
            this.benchmark.runs = runs;
            return this;
        }

        public BenchmarkBuilder withPrewarmRuns(int prewarmRuns) {
            this.benchmark.prewarmRuns = prewarmRuns;
            return this;
        }

        public BenchmarkBuilder withConcurrency(int concurrency) {
            Preconditions.checkArgument((concurrency >= 1 ? 1 : 0) != 0, (Object)"Concurrency must be greater of equal 1");
            this.benchmark.concurrency = concurrency;
            return this;
        }

        public BenchmarkBuilder withBeforeBenchmarkMacros(List<String> beforeBenchmarkMacros) {
            this.benchmark.beforeBenchmarkMacros = (List)ImmutableList.copyOf(beforeBenchmarkMacros);
            return this;
        }

        public BenchmarkBuilder withAfterBenchmarkMacros(List<String> afterBenchmarkMacros) {
            this.benchmark.afterBenchmarkMacros = (List)ImmutableList.copyOf(afterBenchmarkMacros);
            return this;
        }

        public BenchmarkBuilder withBeforeExecutionMacros(List<String> beforeExecutionMacros) {
            this.benchmark.beforeExecutionMacros = (List)ImmutableList.copyOf(beforeExecutionMacros);
            return this;
        }

        public BenchmarkBuilder withAfterExecutionMacros(List<String> afterExecutionMacros) {
            this.benchmark.afterExecutionMacros = (List)ImmutableList.copyOf(afterExecutionMacros);
            return this;
        }

        public BenchmarkBuilder withVariables(Map<String, String> variables) {
            this.benchmark.variables = (Map)ImmutableMap.copyOf(variables);
            return this;
        }

        public BenchmarkBuilder withFrequency(Optional<Duration> frequency) {
            this.benchmark.frequency = frequency;
            return this;
        }

        public Benchmark build() {
            return this.benchmark;
        }
    }
}

