/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.benchto.driver;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.teradata.benchto.driver.BenchmarkExecutionException;
import com.teradata.benchto.driver.execution.BenchmarkExecutionResult;
import java.util.List;

public class FailedBenchmarkExecutionException
extends BenchmarkExecutionException {
    private final List<BenchmarkExecutionResult> failedBenchmarkResults;
    private final int benchmarksCount;

    public FailedBenchmarkExecutionException(List<BenchmarkExecutionResult> failedBenchmarkResults, int benchmarksCount) {
        super(FailedBenchmarkExecutionException.createMessage(failedBenchmarkResults));
        this.failedBenchmarkResults = failedBenchmarkResults;
        this.benchmarksCount = benchmarksCount;
        failedBenchmarkResults.stream().flatMap(benchmarkExecutionResult -> benchmarkExecutionResult.getFailureCauses().stream()).forEach(this::addSuppressed);
    }

    private static String createMessage(List<BenchmarkExecutionResult> failedBenchmarkResults) {
        Preconditions.checkArgument((!failedBenchmarkResults.isEmpty() ? 1 : 0) != 0, (Object)"no failures");
        return String.format("%s benchmarks failed, first failure was: %s", failedBenchmarkResults.size(), Iterables.getFirst(failedBenchmarkResults.get(0).getFailureCauses(), null));
    }

    public List<BenchmarkExecutionResult> getFailedBenchmarkResults() {
        return this.failedBenchmarkResults;
    }

    public int getBenchmarksCount() {
        return this.benchmarksCount;
    }
}

