/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.benchto.driver;

import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Query {
    private final Map<String, String> properties;
    private final String name;
    private final String sqlTemplate;

    public Query(String name, String sqlTemplate, Map<String, String> properties) {
        this.name = Objects.requireNonNull(name);
        this.sqlTemplate = Objects.requireNonNull(sqlTemplate);
        this.properties = Objects.requireNonNull(properties);
    }

    public String getName() {
        return this.name;
    }

    public String getSqlTemplate() {
        return this.sqlTemplate;
    }

    public Optional<String> getProperty(String key) {
        return Optional.ofNullable(this.properties.get(key));
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getOrDefault(key, defaultValue);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("sqlTemplate", (Object)this.sqlTemplate).toString();
    }
}

