/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.benchto.driver.listeners;

import com.google.common.collect.ImmutableList;
import com.google.common.math.LongMath;
import com.teradata.benchto.driver.Benchmark;
import com.teradata.benchto.driver.Measurable;
import com.teradata.benchto.driver.execution.BenchmarkExecutionResult;
import com.teradata.benchto.driver.execution.QueryExecution;
import com.teradata.benchto.driver.execution.QueryExecutionResult;
import com.teradata.benchto.driver.listeners.benchmark.BenchmarkExecutionListener;
import com.teradata.benchto.driver.listeners.measurements.PostExecutionMeasurementProvider;
import com.teradata.benchto.driver.loader.BenchmarkDescriptor;
import com.teradata.benchto.driver.service.BenchmarkServiceClient;
import com.teradata.benchto.driver.service.Measurement;
import com.teradata.benchto.driver.utils.ExceptionUtils;
import java.sql.SQLException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class BenchmarkServiceExecutionListener
implements BenchmarkExecutionListener {
    private static final Duration MAX_CLOCK_DRIFT = Duration.of(1L, ChronoUnit.SECONDS);
    @Autowired
    private AsyncTaskExecutor taskExecutor;
    @Value(value="${benchmark-service.url}")
    private String serviceUrl;
    @Autowired
    private BenchmarkServiceClient benchmarkServiceClient;
    @Autowired
    private List<PostExecutionMeasurementProvider> measurementProviders;

    public int getOrder() {
        return 0;
    }

    @Override
    public Future<?> benchmarkStarted(Benchmark benchmark) {
        this.checkClocksSync();
        return this.taskExecutor.submit(() -> {
            BenchmarkServiceClient.BenchmarkStartRequest.BenchmarkStartRequestBuilder requestBuilder = new BenchmarkServiceClient.BenchmarkStartRequest.BenchmarkStartRequestBuilder(benchmark.getName()).environmentName(benchmark.getEnvironment());
            for (Map.Entry<String, String> variableEntry : benchmark.getVariables().entrySet()) {
                if (BenchmarkDescriptor.RESERVED_KEYWORDS.contains(variableEntry.getKey())) {
                    requestBuilder.addAttribute(variableEntry.getKey(), variableEntry.getValue());
                    continue;
                }
                requestBuilder.addVariable(variableEntry.getKey(), variableEntry.getValue());
            }
            BenchmarkServiceClient.BenchmarkStartRequest request = (BenchmarkServiceClient.BenchmarkStartRequest)requestBuilder.build();
            this.benchmarkServiceClient.startBenchmark(benchmark.getUniqueName(), benchmark.getSequenceId(), request);
        });
    }

    private void checkClocksSync() {
        long approximationPrecision;
        long timeBefore = System.currentTimeMillis();
        long serviceTime = this.benchmarkServiceClient.getServiceCurrentTime().toEpochMilli();
        long timeAfter = System.currentTimeMillis();
        long driftApproximation = Math.abs(LongMath.mean((long)timeBefore, (long)timeAfter) - serviceTime);
        Duration driftLowerBound = Duration.of(driftApproximation - (approximationPrecision = timeAfter - LongMath.mean((long)timeBefore, (long)timeAfter)), ChronoUnit.MILLIS);
        if (driftLowerBound.compareTo(MAX_CLOCK_DRIFT) > 1) {
            throw new RuntimeException(String.format("Detected driver and service clocks drift of at least %s, assumed sane maximum is %s", driftLowerBound, MAX_CLOCK_DRIFT));
        }
    }

    @Override
    public Future<?> benchmarkFinished(BenchmarkExecutionResult benchmarkExecutionResult) {
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> this.getMeasurements(benchmarkExecutionResult), arg_0 -> ((AsyncTaskExecutor)this.taskExecutor).execute(arg_0)).thenCompose(future -> future)).thenApply(measurements -> (BenchmarkServiceClient.FinishRequest)new BenchmarkServiceClient.FinishRequest.FinishRequestBuilder().withStatus(benchmarkExecutionResult.isSuccessful() ? BenchmarkServiceClient.FinishRequest.Status.ENDED : BenchmarkServiceClient.FinishRequest.Status.FAILED).withEndTime(benchmarkExecutionResult.getUtcEnd().toInstant()).addMeasurements((Collection<Measurement>)measurements).build())).thenAccept(request -> this.benchmarkServiceClient.finishBenchmark(benchmarkExecutionResult.getBenchmark().getUniqueName(), benchmarkExecutionResult.getBenchmark().getSequenceId(), (BenchmarkServiceClient.FinishRequest)request));
    }

    @Override
    public Future<?> executionStarted(QueryExecution execution) {
        return this.taskExecutor.submit(() -> {
            BenchmarkServiceClient.ExecutionStartRequest request = (BenchmarkServiceClient.ExecutionStartRequest)new BenchmarkServiceClient.ExecutionStartRequest.ExecutionStartRequestBuilder().build();
            this.benchmarkServiceClient.startExecution(execution.getBenchmark().getUniqueName(), execution.getBenchmark().getSequenceId(), this.executionSequenceId(execution), request);
        });
    }

    @Override
    public Future<?> executionFinished(QueryExecutionResult executionResult) {
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> this.getMeasurements(executionResult), arg_0 -> ((AsyncTaskExecutor)this.taskExecutor).execute(arg_0)).thenCompose(future -> future)).thenApply(measurements -> this.buildExecutionFinishedRequest(executionResult, (List<Measurement>)measurements))).thenAccept(request -> this.benchmarkServiceClient.finishExecution(executionResult.getBenchmark().getUniqueName(), executionResult.getBenchmark().getSequenceId(), this.executionSequenceId(executionResult.getQueryExecution()), (BenchmarkServiceClient.FinishRequest)request));
    }

    private BenchmarkServiceClient.FinishRequest buildExecutionFinishedRequest(QueryExecutionResult executionResult, List<Measurement> measurements) {
        BenchmarkServiceClient.FinishRequest.FinishRequestBuilder requestBuilder = new BenchmarkServiceClient.FinishRequest.FinishRequestBuilder().withStatus(executionResult.isSuccessful() ? BenchmarkServiceClient.FinishRequest.Status.ENDED : BenchmarkServiceClient.FinishRequest.Status.FAILED).withEndTime(executionResult.getUtcEnd().toInstant()).addMeasurements(measurements);
        if (executionResult.getPrestoQueryId().isPresent()) {
            requestBuilder.addAttribute("prestoQueryId", executionResult.getPrestoQueryId().get());
        }
        if (!executionResult.isSuccessful()) {
            requestBuilder.addAttribute("failureMessage", executionResult.getFailureCause().getMessage());
            requestBuilder.addAttribute("failureStackTrace", ExceptionUtils.stackTraceToString(executionResult));
            if (executionResult.getFailureCause() instanceof SQLException) {
                requestBuilder.addAttribute("failureSQLErrorCode", "" + ((SQLException)executionResult.getFailureCause()).getErrorCode());
            }
        }
        return (BenchmarkServiceClient.FinishRequest)requestBuilder.build();
    }

    private CompletableFuture<List<Measurement>> getMeasurements(Measurable measurable) {
        ArrayList<CompletionStage> providerFutures = new ArrayList<CompletionStage>();
        List measurementsList = Collections.synchronizedList(new ArrayList());
        for (PostExecutionMeasurementProvider measurementProvider : this.measurementProviders) {
            CompletionStage future = measurementProvider.loadMeasurements(measurable).thenAccept(measurementsList::addAll);
            providerFutures.add(future);
        }
        return CompletableFuture.allOf((CompletableFuture[])providerFutures.stream().toArray(CompletableFuture[]::new)).thenApply(aVoid -> ImmutableList.copyOf((Collection)measurementsList));
    }

    private String executionSequenceId(QueryExecution execution) {
        return "" + execution.getRun();
    }
}

