/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.benchto.driver.listeners.measurements;

import com.google.common.collect.ImmutableList;
import com.teradata.benchto.driver.Measurable;
import com.teradata.benchto.driver.execution.BenchmarkExecutionResult;
import com.teradata.benchto.driver.execution.QueryExecutionResult;
import com.teradata.benchto.driver.listeners.measurements.PostExecutionMeasurementProvider;
import com.teradata.benchto.driver.service.Measurement;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.springframework.stereotype.Component;

@Component
public class DurationMeasurementProvider
implements PostExecutionMeasurementProvider {
    @Override
    public CompletableFuture<List<Measurement>> loadMeasurements(Measurable measurable) {
        ImmutableList measurements = this.shouldMeasureDuration(measurable) ? ImmutableList.of((Object)Measurement.measurement("duration", "MILLISECONDS", measurable.getQueryDuration().toMillis())) : ImmutableList.of();
        return CompletableFuture.completedFuture(measurements);
    }

    private boolean shouldMeasureDuration(Measurable measurable) {
        if (measurable instanceof QueryExecutionResult) {
            return true;
        }
        return measurable instanceof BenchmarkExecutionResult && measurable.getBenchmark().isConcurrent();
    }
}

