/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.benchto.driver.macro.query;

import com.facebook.presto.jdbc.PrestoConnection;
import com.google.common.base.Preconditions;
import com.teradata.benchto.driver.Benchmark;
import com.teradata.benchto.driver.BenchmarkExecutionException;
import com.teradata.benchto.driver.Query;
import com.teradata.benchto.driver.loader.QueryLoader;
import com.teradata.benchto.driver.loader.SqlStatementGenerator;
import com.teradata.benchto.driver.macro.MacroExecutionDriver;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class QueryMacroExecutionDriver
implements MacroExecutionDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryMacroExecutionDriver.class);
    private static final String SET_SESSION = "set session";
    private static final Pattern KEY_VALUE_PATTERN = Pattern.compile("([^=]+)='??([^']+)'??");
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private QueryLoader queryLoader;
    @Autowired
    private SqlStatementGenerator sqlStatementGenerator;

    @Override
    public boolean canExecuteBenchmarkMacro(String macroName) {
        return macroName.endsWith(".sql");
    }

    @Override
    public void runBenchmarkMacro(String macroName, Optional<Benchmark> benchmarkOptional, Optional<Connection> connectionOptional) {
        block15: {
            Preconditions.checkArgument((boolean)benchmarkOptional.isPresent(), (Object)"Benchmark is required to run query based macro");
            Benchmark benchmark = benchmarkOptional.get();
            Query macroQuery = this.queryLoader.loadFromFile(macroName);
            List<String> sqlStatements = this.sqlStatementGenerator.generateQuerySqlStatement(macroQuery, benchmark.getNonReservedKeywordVariables());
            try {
                if (connectionOptional.isPresent() && !macroQuery.getProperty("datasource").isPresent()) {
                    this.runSqlStatements(connectionOptional.get(), sqlStatements);
                    break block15;
                }
                String dataSourceName = macroQuery.getProperty("datasource", benchmark.getDataSource());
                try (Connection connection = this.getConnectionFor(dataSourceName);){
                    this.runSqlStatements(connection, sqlStatements);
                }
            }
            catch (SQLException e) {
                throw new BenchmarkExecutionException("Could not execute macro SQL queries for benchmark: " + benchmark, e);
            }
        }
    }

    private void runSqlStatements(Connection connection, List<String> sqlStatements) throws SQLException {
        for (String sqlStatement : sqlStatements) {
            sqlStatement = sqlStatement.trim();
            LOGGER.info("Executing macro query: {}", (Object)sqlStatement);
            if (sqlStatement.toLowerCase().startsWith(SET_SESSION) && connection.isWrapperFor(PrestoConnection.class)) {
                this.setSessionForPresto(connection, sqlStatement);
                continue;
            }
            Statement statement = connection.createStatement();
            Throwable throwable = null;
            try {
                statement.execute(sqlStatement);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (statement == null) continue;
                if (throwable != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                statement.close();
            }
        }
    }

    private void setSessionForPresto(Connection connection, String sqlStatement) {
        PrestoConnection prestoConnection;
        try {
            prestoConnection = connection.unwrap(PrestoConnection.class);
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage());
            throw new UnsupportedOperationException(String.format("SET SESSION for non PrestoConnection [%s] is not supported", connection.getClass()));
        }
        String[] keyValue = QueryMacroExecutionDriver.extractKeyValue(sqlStatement);
        prestoConnection.setSessionProperty(keyValue[0].trim(), keyValue[1].trim());
    }

    public static String[] extractKeyValue(String sqlStatement) {
        String keyValueSql = sqlStatement.substring(SET_SESSION.length(), sqlStatement.length()).trim();
        Matcher matcher = KEY_VALUE_PATTERN.matcher(keyValueSql);
        Preconditions.checkState((boolean)matcher.matches(), (String)"Unexpected SET SESSION format [%s]", (Object)sqlStatement);
        String[] keyValue = new String[]{matcher.group(1).trim(), matcher.group(2).trim()};
        return keyValue;
    }

    private Connection getConnectionFor(String dataSourceName) throws SQLException {
        return ((DataSource)this.applicationContext.getBean(dataSourceName, DataSource.class)).getConnection();
    }
}

