/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.benchto.driver.service;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.google.common.base.MoreObjects;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class Measurement {
    private String name;
    private String unit;
    private double value;

    public static Measurement measurement(String name, String unit, double value) {
        Measurement measurement = new Measurement();
        measurement.name = Objects.requireNonNull(name);
        measurement.unit = Objects.requireNonNull(unit);
        measurement.value = value;
        return measurement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Measurement that = (Measurement)o;
        return Double.compare(that.value, this.value) == 0 && this.name.equals(that.name) && this.unit.equals(that.unit);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.unit.hashCode();
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("unit", (Object)this.unit).add("value", this.value).toString();
    }
}

