/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.benchto.driver.execution;

import com.google.common.base.MoreObjects;
import com.teradata.benchto.driver.Benchmark;
import com.teradata.benchto.driver.Measurable;
import com.teradata.benchto.driver.execution.QueryExecutionResult;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class BenchmarkExecutionResult
extends Measurable {
    private final Benchmark benchmark;
    private Optional<Exception> failure = Optional.empty();
    private List<QueryExecutionResult> executions;

    private BenchmarkExecutionResult(Benchmark benchmark) {
        this.benchmark = benchmark;
    }

    @Override
    public Benchmark getBenchmark() {
        return this.benchmark;
    }

    @Override
    public String getEnvironment() {
        return this.benchmark.getEnvironment();
    }

    public List<QueryExecutionResult> getExecutions() {
        return this.executions;
    }

    @Override
    public boolean isSuccessful() {
        return !this.failure.isPresent() && this.executions.stream().allMatch(QueryExecutionResult::isSuccessful);
    }

    public List<Exception> getFailureCauses() {
        List<Exception> failureCauses = this.executions.stream().filter(queryExecutionResult -> !queryExecutionResult.isSuccessful()).map(QueryExecutionResult::getFailureCause).collect(Collectors.toList());
        this.failure.ifPresent(failureCauses::add);
        return failureCauses;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("benchmark", (Object)this.benchmark.getName()).add("successful", this.isSuccessful()).add("duration", (Object)(this.getQueryDuration().toMillis() + " ms")).toString();
    }

    public static class BenchmarkExecutionResultBuilder
    extends Measurable.MeasuredBuilder<BenchmarkExecutionResult, BenchmarkExecutionResultBuilder> {
        public BenchmarkExecutionResultBuilder(Benchmark benchmark) {
            super(new BenchmarkExecutionResult(benchmark));
        }

        public BenchmarkExecutionResultBuilder withUnexpectedException(Exception failure) {
            ((BenchmarkExecutionResult)this.object).failure = Optional.of(failure);
            ((BenchmarkExecutionResult)this.object).executions = Collections.emptyList();
            return this;
        }

        public BenchmarkExecutionResultBuilder withExecutions(List<QueryExecutionResult> executions) {
            ((BenchmarkExecutionResult)this.object).executions = executions;
            return this;
        }

        @Override
        public BenchmarkExecutionResult build() {
            Objects.requireNonNull(((BenchmarkExecutionResult)this.object).executions, "Executions are not set");
            return (BenchmarkExecutionResult)super.build();
        }
    }
}

