/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.benchto.driver.listeners;

import com.teradata.benchto.driver.Benchmark;
import com.teradata.benchto.driver.execution.BenchmarkExecutionResult;
import com.teradata.benchto.driver.execution.ExecutionSynchronizer;
import com.teradata.benchto.driver.execution.QueryExecution;
import com.teradata.benchto.driver.execution.QueryExecutionResult;
import com.teradata.benchto.driver.graphite.GraphiteClient;
import com.teradata.benchto.driver.listeners.benchmark.BenchmarkExecutionListener;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="benchmark.feature.graphite", value={"event.reporting.enabled"})
public class GraphiteEventExecutionListener
implements BenchmarkExecutionListener {
    @Autowired
    private AsyncTaskExecutor taskExecutor;
    @Autowired
    private ExecutionSynchronizer executionSynchronizer;
    @Autowired
    private GraphiteClient graphiteClient;

    public int getOrder() {
        return 0;
    }

    @Override
    public Future<?> benchmarkStarted(Benchmark benchmark) {
        GraphiteClient.GraphiteEventRequest request = new GraphiteClient.GraphiteEventRequest.GraphiteEventRequestBuilder().what(String.format("Benchmark %s started", benchmark.getUniqueName())).tags("benchmark", "started", benchmark.getEnvironment()).build();
        return this.taskExecutor.submit(() -> this.graphiteClient.storeEvent(request));
    }

    @Override
    public Future<?> benchmarkFinished(BenchmarkExecutionResult benchmarkExecutionResult) {
        GraphiteClient.GraphiteEventRequest request = new GraphiteClient.GraphiteEventRequest.GraphiteEventRequestBuilder().what(String.format("Benchmark %s ended", benchmarkExecutionResult.getBenchmark().getUniqueName())).tags("benchmark", "ended", benchmarkExecutionResult.getEnvironment()).data(String.format("successful %b", benchmarkExecutionResult.isSuccessful())).when(benchmarkExecutionResult.getUtcEnd()).build();
        Future future = this.taskExecutor.submit(() -> this.graphiteClient.storeEvent(request));
        this.executionSynchronizer.awaitAfterBenchmarkExecutionAndBeforeResultReport(benchmarkExecutionResult.getBenchmark());
        return future;
    }

    @Override
    public Future<?> executionStarted(QueryExecution execution) {
        if (execution.getBenchmark().isConcurrent()) {
            return CompletableFuture.completedFuture("");
        }
        GraphiteClient.GraphiteEventRequest request = new GraphiteClient.GraphiteEventRequest.GraphiteEventRequestBuilder().what(String.format("Benchmark %s, query %s (%d) started", execution.getBenchmark().getUniqueName(), execution.getQueryName(), execution.getRun())).tags("execution", "started", execution.getBenchmark().getEnvironment()).build();
        return this.taskExecutor.submit(() -> this.graphiteClient.storeEvent(request));
    }

    @Override
    public Future<?> executionFinished(QueryExecutionResult executionResult) {
        if (executionResult.getBenchmark().isConcurrent()) {
            return CompletableFuture.completedFuture("");
        }
        QueryExecution queryExecution = executionResult.getQueryExecution();
        GraphiteClient.GraphiteEventRequest request = new GraphiteClient.GraphiteEventRequest.GraphiteEventRequestBuilder().what(String.format("Benchmark %s, query %s (%d) ended", queryExecution.getBenchmark().getUniqueName(), executionResult.getQueryName(), queryExecution.getRun())).tags("execution", "ended", executionResult.getEnvironment()).data(String.format("duration: %d ms", executionResult.getQueryDuration().toMillis())).when(executionResult.getUtcEnd()).build();
        Future future = this.taskExecutor.submit(() -> this.graphiteClient.storeEvent(request));
        this.executionSynchronizer.awaitAfterQueryExecutionAndBeforeResultReport(executionResult);
        return future;
    }
}

