/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.benchto.driver.presto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.teradata.benchto.driver.BenchmarkProperties;
import com.teradata.benchto.driver.service.Measurement;
import com.teradata.benchto.driver.utils.UnitConverter;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component
@ConditionalOnProperty(prefix="presto", value={"url"})
public class PrestoClient {
    private static final Map<String, Unit> DEFAULT_METRICS = ImmutableMap.builder().put((Object)"totalPlanningTime", (Object)SI.MILLI((Unit)SI.SECOND)).put((Object)"totalScheduledTime", (Object)SI.MILLI((Unit)SI.SECOND)).put((Object)"totalCpuTime", (Object)SI.MILLI((Unit)SI.SECOND)).put((Object)"totalUserTime", (Object)SI.MILLI((Unit)SI.SECOND)).put((Object)"totalBlockedTime", (Object)SI.MILLI((Unit)SI.SECOND)).put((Object)"processedInputDataSize", (Object)NonSI.BYTE).put((Object)"outputDataSize", (Object)NonSI.BYTE).put((Object)"peakMemoryReservation", (Object)NonSI.BYTE).build();
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private BenchmarkProperties properties;

    @Retryable(value={RestClientException.class}, backoff=@Backoff(value=1000L))
    public List<Measurement> loadMetrics(String queryId) {
        return this.loadMetrics(queryId, DEFAULT_METRICS);
    }

    private List<Measurement> loadMetrics(String queryId, Map<String, Unit> requiredStatistics) {
        URI uri = this.buildQueryInfoURI(queryId);
        ResponseEntity response = this.restTemplate.getForEntity(uri, QueryInfoResponseItem.class);
        Map<String, Object> queryStats = ((QueryInfoResponseItem)response.getBody()).getQueryStats();
        return queryStats.keySet().stream().filter(requiredStatistics::containsKey).map(name -> this.parseQueryStatistic((String)name, queryStats.get(name), (Unit)requiredStatistics.get(name))).collect(Collectors.toList());
    }

    private URI buildQueryInfoURI(String queryId) {
        Preconditions.checkState((!this.properties.getPrestoURL().isEmpty() ? 1 : 0) != 0);
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)this.properties.getPrestoURL()).pathSegment(new String[]{"v1", "query", queryId});
        return URI.create(uriBuilder.toUriString());
    }

    private Measurement parseQueryStatistic(String name, Object statistic, Unit requiredUnit) {
        double value = UnitConverter.parseValueAsUnit(statistic.toString(), requiredUnit);
        return Measurement.measurement("prestoQuery-" + name, UnitConverter.format(requiredUnit), value);
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    public static class QueryInfoResponseItem {
        private Map<String, Object> queryStats;

        Map<String, Object> getQueryStats() {
            return this.queryStats;
        }
    }
}

